/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.WindowPane;
import org.hibernate.validator.internal.util.Contracts;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.print.PrintDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.charge.ChargeCRUDWindow;
import org.springframework.beans.factory.annotation.Autowired;

public class ChargeCRUDWindowTestCase
extends AbstractAppTest {
    private final List<String> errors = new ArrayList<String>();
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    private Context context;

    @Before
    public void setUp() {
        super.setUp();
        this.context = new LocalContext();
        this.context.setPractice(this.practiceFactory.getPractice());
        this.context.setLocation(this.practiceFactory.createLocation());
        this.initErrorHandler(this.errors);
    }

    @Test
    public void testEditCharge() {
        this.checkEditPostedCharge(this.createInvoice());
        this.checkEditPostedCharge(this.createCredit());
        this.checkEditPostedCharge(this.createCounterSale());
    }

    @Test
    public void testEditDeletedCharge() {
        this.checkEditDeletedCharge(this.createInvoice());
        this.checkEditDeletedCharge(this.createCredit());
        this.checkEditDeletedCharge(this.createCounterSale());
    }

    @Test
    public void testPost() {
        this.checkPost(this.createInvoice());
        this.checkPost(this.createCredit());
        this.checkPost(this.createCounterSale());
    }

    @Test
    public void testPostAlreadyPosted() {
        this.checkPostAlreadyPosted(this.createInvoice());
        this.checkPostAlreadyPosted(this.createCredit());
        this.checkPostAlreadyPosted(this.createCounterSale());
    }

    @Test
    public void testPostDeleted() {
        this.checkPostDeleted(this.createInvoice());
        this.checkPostDeleted(this.createCredit());
        this.checkPostDeleted(this.createCounterSale());
    }

    private void checkEditPostedCharge(FinancialAct charge) {
        this.errors.clear();
        ChargeCRUDWindow window = this.createWindow(charge);
        Assert.assertTrue((boolean)window.canEdit());
        FinancialAct copy = (FinancialAct)this.get((IMObject)charge);
        copy.setStatus("POSTED");
        this.save((IMObject)copy);
        Assert.assertTrue((boolean)window.canEdit());
        window.edit();
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)("Can't edit " + this.getDisplayName((IMObject)charge)), (Object)this.errors.get(0));
    }

    private void checkEditDeletedCharge(FinancialAct charge) {
        this.errors.clear();
        ChargeCRUDWindow window = this.createWindow(charge);
        Assert.assertTrue((boolean)window.canEdit());
        this.remove((IMObject)charge);
        Assert.assertTrue((boolean)window.canEdit());
        window.edit();
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)(this.getDisplayName((IMObject)charge) + " no longer exists"), (Object)this.errors.get(0));
    }

    private void checkPost(FinancialAct charge) {
        this.errors.clear();
        ChargeCRUDWindow window = this.createWindow(charge);
        EchoTestHelper.fireButton((Component)window.getComponent(), (String)"button.post");
        String displayName = this.getDisplayName((IMObject)charge);
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)("Finalise " + displayName), (String)("Are you sure you want to Finalise the " + displayName + "?"), (String)"ok");
        FinancialAct reloaded = (FinancialAct)this.get((IMObject)charge);
        Assert.assertEquals((Object)"POSTED", (Object)reloaded.getStatus());
        Assert.assertEquals((Object)reloaded, (Object)window.getObject());
        Assert.assertEquals((long)reloaded.getVersion(), (long)((FinancialAct)window.getObject()).getVersion());
        if (charge.isA(new String[]{"act.customerAccountChargesInvoice", "act.customerAccountChargesCounter"})) {
            EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)"Pay Account", (String)"Do you wish to pay the account?", (String)"yes");
        } else {
            Contracts.assertNotNull((Object)EchoTestHelper.findWindowPane(PrintDialog.class));
        }
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    private void checkPostAlreadyPosted(FinancialAct charge) {
        this.errors.clear();
        ChargeCRUDWindow window = this.createWindow(charge);
        FinancialAct copy = (FinancialAct)this.get((IMObject)charge);
        copy.setStatus("POSTED");
        this.save((IMObject)copy);
        EchoTestHelper.fireButton((Component)window.getComponent(), (String)"button.post");
        Assert.assertNull((Object)window.getObject());
        Assert.assertTrue((boolean)this.errors.isEmpty());
        Assert.assertNull((Object)EchoTestHelper.findWindowPane(WindowPane.class));
    }

    private void checkPostDeleted(FinancialAct charge) {
        this.errors.clear();
        ChargeCRUDWindow window = this.createWindow(charge);
        this.remove((IMObject)charge);
        EchoTestHelper.fireButton((Component)window.getComponent(), (String)"button.post");
        Assert.assertNull((Object)window.getObject());
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)(this.getDisplayName((IMObject)charge) + " no longer exists"), (Object)this.errors.get(0));
        Assert.assertNull((Object)EchoTestHelper.findWindowPane(WindowPane.class));
    }

    private ChargeCRUDWindow createWindow(FinancialAct charge) {
        IMObjectBean bean = this.getBean((IMObject)charge);
        this.context.setCustomer((Party)bean.getTarget("customer", Party.class));
        Archetypes archetypes = Archetypes.create((String)"act.customerAccountCharges*", FinancialAct.class);
        ChargeCRUDWindow window = new ChargeCRUDWindow(archetypes, this.context, new HelpContext("foo", null));
        window.setObject(charge);
        return window;
    }

    private FinancialAct createInvoice() {
        return this.accountFactory.createInvoice(10, "IN_PROGRESS");
    }

    private FinancialAct createCredit() {
        return this.accountFactory.createCredit(10, "IN_PROGRESS");
    }

    private FinancialAct createCounterSale() {
        return this.accountFactory.createCounterSale(10, "IN_PROGRESS");
    }
}

