/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account;

import java.math.BigDecimal;
import java.util.Date;
import nextapp.echo2.app.Component;
import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestBadDebtBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCreditAdjustBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestDebitAdjustBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestEFTPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestEFTRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestRefundBuilder;
import org.openvpms.archetype.test.builder.eft.TestEFTPOSPaymentBuilder;
import org.openvpms.archetype.test.builder.eft.TestEFTPOSRefundBuilder;
import org.openvpms.archetype.test.builder.paymentprocessor.TestPaymentProcessorFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.paymentprocessor.transaction.Transaction;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.account.ReverseConfirmationDialog;
import org.openvpms.web.workspace.customer.account.Reverser;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditDialog;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditor;
import org.openvpms.web.workspace.customer.payment.EFTPaymentDialog;
import org.openvpms.web.workspace.customer.payment.PaymentProcessorStatusDialog;
import org.openvpms.web.workspace.customer.payment.TestCustomerPaymentEditor;
import org.openvpms.web.workspace.customer.payment.TestEFTPOSService;
import org.openvpms.web.workspace.customer.payment.TestPaymentProcessorService;
import org.springframework.beans.factory.annotation.Autowired;

public class ReverserTestCase
extends AbstractAppTest {
    @Autowired
    private CustomerAccountRules accountRules;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPaymentProcessorFactory paymentProcessorFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestUserFactory userFactory;
    private TestPaymentProcessorService paymentProcessorService;

    @Before
    public void setUp() {
        super.setUp();
        this.paymentProcessorService = new TestPaymentProcessorService();
    }

    @Test
    public void testReverseCashPayment() {
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("POSTED")).customer(this.customerFactory.createCustomer())).till(this.practiceFactory.createTill())).cash(BigDecimal.TEN).build();
        this.verifyReverseSucceeds(payment);
    }

    @Test
    public void testReverseCashRefund() {
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("POSTED")).customer(this.customerFactory.createCustomer())).till(this.practiceFactory.createTill())).cash(BigDecimal.TEN).build();
        this.verifyReverseSucceeds(refund);
    }

    @Test
    public void testReverseEFTPayment() {
        Party customer = this.customerFactory.createCustomer();
        FinancialAct transaction = (FinancialAct)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)this.accountFactory.newEFTPOSPayment().customer(customer)).amount(BigDecimal.TEN)).location(this.practiceFactory.createLocation())).status("NO_TERMINAL")).build();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("POSTED")).customer(customer)).till(this.practiceFactory.createTill())).eft().amount(BigDecimal.TEN)).addTransaction(transaction)).add()).build();
        this.verifyReverseSucceeds(payment);
    }

    @Test
    public void testReverseEFTRefund() {
        Party customer = this.customerFactory.createCustomer();
        FinancialAct transaction = (FinancialAct)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)this.accountFactory.newEFTPOSRefund().customer(customer)).amount(BigDecimal.TEN)).location(this.practiceFactory.createLocation())).status("NO_TERMINAL")).build();
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("POSTED")).customer(customer)).till(this.practiceFactory.createTill())).eft().amount(BigDecimal.TEN)).addTransaction(transaction)).add()).build();
        this.verifyReverseSucceeds(refund);
    }

    @Test
    public void testReverseUnposted() {
        FinancialAct invoice = (FinancialAct)((TestInvoiceBuilder)((TestInvoiceBuilder)this.accountFactory.newInvoice().customer(this.customerFactory.createCustomer())).location(this.practiceFactory.createLocation())).build();
        for (String status : new String[]{"IN_PROGRESS", "COMPLETED", "ON_HOLD"}) {
            invoice.setStatus(status);
            this.save((IMObject)invoice);
            try {
                Reverser reverser = this.createReverser();
                reverser.reverse(invoice, reversal -> Assert.fail((String)"Listener should not have been called."));
                Assert.fail((String)"Expected reverse to fail");
            }
            catch (IllegalArgumentException expected) {
                Assert.assertEquals((Object)"Argument 'act' is not POSTED", (Object)expected.getMessage());
            }
        }
    }

    @Test
    public void testReverseReversal() {
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("POSTED")).customer(this.customerFactory.createCustomer())).location(this.practiceFactory.createLocation())).till(this.practiceFactory.createTill())).cash(100).build();
        FinancialAct refund = this.accountRules.reverse(payment, new Date());
        String title = "Reverse Payment";
        String message = "Cannot reverse Payment.\n\nIt has been reversed by Refund " + NumberFormatter.format((Number)refund.getId());
        this.verifyReverseFails(payment, title, message);
    }

    @Test
    public void testReverseEFTPaymentWithApprovedTransaction() {
        Party customer = this.customerFactory.createCustomer();
        FinancialAct transaction = (FinancialAct)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)this.accountFactory.newEFTPOSPayment().customer(customer)).amount(BigDecimal.TEN)).location(this.practiceFactory.createLocation())).terminal(this.practiceFactory.createEFTPOSTerminal())).status("APPROVED")).build();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("POSTED")).customer(customer)).till(this.practiceFactory.createTill())).eft().amount(BigDecimal.TEN)).addTransaction(transaction)).add()).build();
        MutableObject reversal = new MutableObject();
        Assert.assertFalse((boolean)this.accountRules.isReversed(payment));
        Reverser reverser = this.createReverser();
        reverser.reverse(payment, arg_0 -> ((MutableObject)reversal).setValue(arg_0));
        CustomerPaymentEditDialog dialog = (CustomerPaymentEditDialog)EchoTestHelper.getWindowPane(CustomerPaymentEditDialog.class);
        EchoTestHelper.fireButton((Component)dialog, (String)"ok");
        EFTPaymentDialog eftDialog = (EFTPaymentDialog)EchoTestHelper.getWindowPane(EFTPaymentDialog.class);
        this.processQueuedTasks(10, () -> eftDialog.getButtons().isEnabled("ok"));
        EchoTestHelper.fireButton((Component)eftDialog, (String)"ok");
        Assert.assertNotNull((Object)reversal.getValue());
        FinancialAct refund = (FinancialAct)this.get((IMObject)reversal.getValue());
        Assert.assertNotNull((Object)refund);
        Assert.assertEquals((Object)"POSTED", (Object)refund.getStatus());
        IMObjectBean bean = this.getBean((IMObject)refund);
        Assert.assertEquals((Object)Long.toString(payment.getId()), (Object)bean.getString("reference"));
        Assert.assertEquals((Object)("Reversal of Payment " + payment.getId()), (Object)bean.getString("notes"));
        this.checkEquals(BigDecimal.TEN, refund.getTotal());
        Assert.assertTrue((boolean)this.accountRules.hasApprovedEFTPOSTransaction(refund));
        Assert.assertTrue((boolean)this.accountRules.isReversed(payment));
        Assert.assertTrue((boolean)this.accountRules.isReversal(refund));
    }

    @Test
    public void testReverseEFTRefundWithApprovedTransaction() {
        Party customer = this.customerFactory.createCustomer();
        FinancialAct transaction = (FinancialAct)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)this.accountFactory.newEFTPOSRefund().customer(customer)).amount(BigDecimal.TEN)).location(this.practiceFactory.createLocation())).terminal(this.practiceFactory.createEFTPOSTerminal())).status("APPROVED")).build();
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("POSTED")).customer(customer)).till(this.practiceFactory.createTill())).eft().amount(BigDecimal.TEN)).addTransaction(transaction)).add()).build();
        this.verifyReverseFails(refund, "Reverse Refund", "Cannot reverse Refund.\n\nIt has an EFT item which cannot be automatically reversed.\n\nCreate a Payment instead.");
    }

    @Test
    public void testReversePaymentProcessorPaymentForSubmittedTxn() {
        Entity processor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("POSTED")).customer(this.customerFactory.createCustomer())).location(this.practiceFactory.createLocation())).till(this.practiceFactory.createTill())).paymentProcessor().processor(processor)).amount(BigDecimal.TEN)).addTransaction("COMPLETED")).add()).build();
        MutableObject reversal = new MutableObject();
        Assert.assertFalse((boolean)this.accountRules.isReversed(payment));
        Reverser reverser = this.createReverser();
        reverser.reverse(payment, arg_0 -> ((MutableObject)reversal).setValue(arg_0));
        CustomerPaymentEditDialog dialog = (CustomerPaymentEditDialog)EchoTestHelper.getWindowPane(CustomerPaymentEditDialog.class);
        EchoTestHelper.fireButton((Component)dialog, (String)"ok");
        PaymentProcessorStatusDialog statusDialog = (PaymentProcessorStatusDialog)EchoTestHelper.getWindowPane(PaymentProcessorStatusDialog.class);
        EchoTestHelper.fireButton((Component)statusDialog, (String)"ok");
        EchoTestHelper.findMessageDialogAndFireButton(InformationDialog.class, (String)"Edit Refund", (String)("Cannot finalise Refund. It has an outstanding " + processor.getName() + " transaction."), (String)"ok");
        EchoTestHelper.fireButton((Component)dialog, (String)"ok");
        Assert.assertNotNull((Object)reversal.getValue());
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)((FinancialAct)reversal.getValue()).getStatus());
        Assert.assertTrue((boolean)this.accountRules.isReversed(payment));
        FinancialAct transaction = this.accountRules.getPaymentProcessorTransaction((FinancialAct)reversal.getValue());
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)"SUBMITTED", (Object)transaction.getStatus());
    }

    @Test
    public void testReversePaymentProcessorPaymentForCompletedTxn() {
        this.paymentProcessorService.setSubmitCallback(transaction -> transaction.setStatus(Transaction.Status.COMPLETED));
        Entity processor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("POSTED")).customer(this.customerFactory.createCustomer())).location(this.practiceFactory.createLocation())).till(this.practiceFactory.createTill())).paymentProcessor().processor(processor)).amount(BigDecimal.TEN)).addTransaction("COMPLETED")).add()).build();
        MutableObject reversal = new MutableObject();
        Assert.assertFalse((boolean)this.accountRules.isReversed(payment));
        Reverser reverser = this.createReverser();
        reverser.reverse(payment, arg_0 -> ((MutableObject)reversal).setValue(arg_0));
        CustomerPaymentEditDialog dialog = (CustomerPaymentEditDialog)EchoTestHelper.getWindowPane(CustomerPaymentEditDialog.class);
        EchoTestHelper.fireButton((Component)dialog, (String)"ok");
        FinancialAct refund = (FinancialAct)reversal.getValue();
        Assert.assertNotNull((Object)refund);
        Assert.assertEquals((Object)"POSTED", (Object)refund.getStatus());
        IMObjectBean bean = this.getBean((IMObject)refund);
        Assert.assertEquals((Object)Long.toString(payment.getId()), (Object)bean.getString("reference"));
        Assert.assertEquals((Object)("Reversal of Payment " + payment.getId()), (Object)bean.getString("notes"));
        Assert.assertTrue((boolean)this.accountRules.isReversed(payment));
        FinancialAct transaction2 = this.accountRules.getPaymentProcessorTransaction(refund);
        Assert.assertNotNull((Object)transaction2);
        Assert.assertEquals((Object)"COMPLETED", (Object)transaction2.getStatus());
    }

    @Test
    public void testReversePaymentProcessorRefund() {
        FinancialAct payment = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("POSTED")).customer(this.customerFactory.createCustomer())).location(this.practiceFactory.createLocation())).till(this.practiceFactory.createTill())).paymentProcessor().processor(this.paymentProcessorFactory.createPaymentProcessor())).amount(BigDecimal.TEN)).addTransaction("COMPLETED")).add()).build();
        this.verifyReverseFails(payment, "Reverse Refund", "Cannot reverse Refund.\n\nIt has a Payment Processor item which cannot be automatically reversed.\n\nCreate a Payment instead.");
    }

    @Test
    public void testReverseDebitAdjust() {
        FinancialAct act = (FinancialAct)((TestDebitAdjustBuilder)((TestDebitAdjustBuilder)((TestDebitAdjustBuilder)this.accountFactory.newDebitAdjust().amount(100)).customer(this.customerFactory.createCustomer())).status("POSTED")).build();
        this.verifyReverseSucceeds(act);
    }

    @Test
    public void testReverseCreditAdjust() {
        FinancialAct act = (FinancialAct)((TestCreditAdjustBuilder)((TestCreditAdjustBuilder)((TestCreditAdjustBuilder)this.accountFactory.newCreditAdjust().amount(100)).customer(this.customerFactory.createCustomer())).status("POSTED")).build();
        this.verifyReverseSucceeds(act);
    }

    @Test
    public void testReverseBadDebt() {
        FinancialAct act = (FinancialAct)((TestBadDebtBuilder)((TestBadDebtBuilder)((TestBadDebtBuilder)this.accountFactory.newBadDebt().amount(100)).customer(this.customerFactory.createCustomer())).status("POSTED")).build();
        this.verifyReverseSucceeds(act);
    }

    private void verifyReverseSucceeds(FinancialAct act) {
        BigDecimal total = act.getTotal();
        MutableObject mutable = new MutableObject();
        Assert.assertFalse((boolean)this.accountRules.isReversed(act));
        Reverser reverser = this.createReverser();
        reverser.reverse(act, arg_0 -> ((MutableObject)mutable).setValue(arg_0));
        ReverseConfirmationDialog dialog = (ReverseConfirmationDialog)EchoTestHelper.getWindowPane(ReverseConfirmationDialog.class);
        EchoTestHelper.fireButton((Component)dialog, (String)"ok");
        FinancialAct reversal = (FinancialAct)mutable.getValue();
        Assert.assertNotNull((Object)reversal);
        Assert.assertEquals((Object)"POSTED", (Object)reversal.getStatus());
        this.checkEquals(total, reversal.getTotal());
        Assert.assertTrue((boolean)this.accountRules.isReversed(act));
        Assert.assertTrue((boolean)this.accountRules.isReversal(reversal));
    }

    private void verifyReverseFails(FinancialAct act, String title, String message) {
        Reverser reverser = this.createReverser();
        reverser.reverse(act, reversal -> Assert.fail((String)"Listener should not have been called."));
        ErrorDialog dialog = (ErrorDialog)EchoTestHelper.getWindowPane(ErrorDialog.class);
        Assert.assertEquals((Object)title, (Object)dialog.getTitle());
        Assert.assertEquals((Object)message, (Object)dialog.getMessage());
    }

    private Reverser createReverser() {
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        Entity till = (Entity)this.practiceFactory.newTill().terminals(new Entity[]{terminal}).build();
        Party location = (Party)this.practiceFactory.newLocation().addTill(till, true).build();
        User user = this.userFactory.createUser();
        HelpContext help = new HelpContext("foo", null);
        return new Reverser(this.getPracticeService().getPractice(), location, till, terminal, user, help){

            protected CustomerPaymentEditor getPaymentEditor(FinancialAct act, DefaultLayoutContext context) {
                TestCustomerPaymentEditor editor = new TestCustomerPaymentEditor(act, null, (LayoutContext)context);
                editor.setEFTPOSService(new TestEFTPOSService());
                editor.setPaymentProcessorService(ReverserTestCase.this.paymentProcessorService);
                return editor;
            }
        };
    }
}

