/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.type;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditorTest;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.admin.type.DiscountTypeEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class DiscountTypeEditorTestCase
extends AbstractIMObjectEditorTest<DiscountTypeEditor> {
    @Autowired
    private TestProductFactory productFactory;

    public DiscountTypeEditorTestCase() {
        super(DiscountTypeEditor.class, "entity.discountType");
    }

    @Test
    public void testValidation() {
        Entity type = (Entity)this.productFactory.newDiscount().build(false);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        DiscountTypeEditor editor = new DiscountTypeEditor((IMObject)type, null, (LayoutContext)context);
        editor.getComponent();
        editor.setRate(BigDecimal.TEN);
        Assert.assertTrue((boolean)editor.isValid());
        this.checkValidation(editor, "PERCENTAGE", false, null);
        this.checkValidation(editor, "PERCENTAGE", true, null);
        this.checkValidation(editor, "FIXED", false, null);
        this.checkValidation(editor, "FIXED", true, "Include Fixed Amount cannot be selected for Fixed discounts");
        this.checkValidation(editor, "COST_RATE", false, null);
        this.checkValidation(editor, "COST_RATE", true, null);
    }

    private void checkValidation(DiscountTypeEditor editor, String type, boolean discountFixed, String message) {
        editor.setType(type);
        editor.setDiscountFixed(discountFixed);
        if (message == null) {
            Assert.assertTrue((boolean)editor.isValid());
        } else {
            EditorTestHelper.assertInvalid((Modifiable)editor, (String)message);
        }
    }
}

