/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.organisation.worklist;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.scheduling.TestTaskBuilder;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandler;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.admin.organisation.worklist.WorkListDeletionHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkListDeletionHandlerTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;

    @Test
    public void testDeleteWorkListWithNoRelationships() {
        Entity workList = this.schedulingFactory.createWorkList();
        WorkListDeletionHandler handler = this.createDeletionHandler(workList);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)workList));
    }

    @Test
    public void testDeleteWorkListWithTaskTypes() {
        Entity taskType = this.schedulingFactory.createTaskType();
        Entity workList = (Entity)this.schedulingFactory.newWorkList().taskTypes(new Entity[]{taskType}).build();
        WorkListDeletionHandler handler = this.createDeletionHandler(workList);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)workList));
        Assert.assertNotNull((Object)this.get((IMObject)taskType));
    }

    @Test
    public void testDeleteWorkListWithTemplates() {
        Entity template = this.documentFactory.createTemplate("act.patientDocumentLetter");
        Entity workList = (Entity)this.schedulingFactory.newWorkList().addTemplates(new Entity[]{template}).build();
        WorkListDeletionHandler handler = this.createDeletionHandler(workList);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)workList));
        Assert.assertNotNull((Object)this.get((IMObject)template));
    }

    @Test
    public void testDeleteWorkListWithActs() {
        Entity workList = this.schedulingFactory.createWorkList();
        WorkListDeletionHandler handler = this.createDeletionHandler(workList);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        ((TestTaskBuilder)((TestTaskBuilder)((TestTaskBuilder)this.schedulingFactory.newTask().startTime(new Date())).workList(workList).taskType(this.schedulingFactory.createTaskType()).customer(this.customerFactory.createCustomer())).patient(this.patientFactory.createPatient())).build();
        Assert.assertFalse((boolean)handler.getDeletable().canDelete());
    }

    @Test
    public void testDeleteWorkListInViews() {
        Entity workList = this.schedulingFactory.createWorkList();
        Entity view = this.schedulingFactory.createWorkListView(new Entity[]{workList});
        WorkListDeletionHandler handler = this.createDeletionHandler(workList);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)workList));
        Assert.assertNotNull((Object)this.get((IMObject)view));
    }

    @Test
    public void testDeactivate() {
        Entity workList = this.schedulingFactory.createWorkList();
        Assert.assertTrue((boolean)workList.isActive());
        WorkListDeletionHandler handler = this.createDeletionHandler(workList);
        handler.deactivate();
        Assert.assertFalse((boolean)((Entity)this.get((IMObject)workList)).isActive());
    }

    @Test
    public void testFactory() {
        IMObjectDeletionHandlerFactory factory = new IMObjectDeletionHandlerFactory(this.getArchetypeService());
        Assert.assertNotNull((Object)this.applicationContext);
        factory.setApplicationContext(this.applicationContext);
        Entity workList = this.schedulingFactory.createWorkList();
        IMObjectDeletionHandler handler = factory.create((IMObject)workList);
        Assert.assertTrue((boolean)(handler instanceof WorkListDeletionHandler));
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)workList));
    }

    protected WorkListDeletionHandler createDeletionHandler(Entity workList) {
        return new WorkListDeletionHandler(workList, this.factory, ServiceHelper.getTransactionManager(), ServiceHelper.getArchetypeService());
    }
}

