/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.lookup;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.admin.lookup.SuburbLookupEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class SuburbLookupEditorTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;
    @Autowired
    private TestLookupFactory lookupFactory;

    @Test
    public void testCodeForNameAndPostcode() {
        Lookup lookup = this.createSuburb();
        Lookup state = this.getState("VIC");
        SuburbLookupEditor editor = this.createEditor(lookup);
        Assert.assertFalse((boolean)editor.isValid());
        String name = TestHelper.randomName((String)"Suburb");
        editor.getProperty("name").setValue((Object)name);
        Assert.assertEquals((Object)name.toUpperCase(), (Object)editor.getCode());
        Assert.assertEquals((Object)name, (Object)lookup.getDescription());
        String postcode = "9999";
        editor.setPostcode(postcode);
        String code = name.toUpperCase() + "_" + postcode;
        Assert.assertEquals((Object)code, (Object)editor.getCode());
        editor.setState((org.openvpms.component.model.lookup.Lookup)state);
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        lookup = (Lookup)this.get((IMObject)lookup);
        Assert.assertEquals((Object)code, (Object)lookup.getCode());
        Assert.assertEquals((Object)name, (Object)lookup.getName());
        Assert.assertEquals((Object)(name + " " + postcode), (Object)lookup.getDescription());
        editor.setPostcode("1111");
        Assert.assertEquals((Object)code, (Object)editor.getCode());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        lookup = (Lookup)this.get((IMObject)lookup);
        Assert.assertEquals((Object)code, (Object)lookup.getCode());
    }

    @Test
    public void testCodeForNameAndState() {
        Lookup lookup = this.createSuburb();
        Lookup state = this.getState("VIC");
        SuburbLookupEditor editor = this.createEditor(lookup);
        Assert.assertFalse((boolean)editor.isValid());
        String name = TestHelper.randomName((String)"Suburb");
        editor.getProperty("name").setValue((Object)name);
        editor.setState((org.openvpms.component.model.lookup.Lookup)state);
        String code = name.toUpperCase() + "_" + state.getCode();
        Assert.assertEquals((Object)code, (Object)editor.getCode());
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        lookup = (Lookup)this.get((IMObject)lookup);
        Assert.assertEquals((Object)code, (Object)lookup.getCode());
        Assert.assertEquals((Object)name, (Object)lookup.getName());
        Assert.assertEquals((Object)name, (Object)lookup.getDescription());
        editor.setState((org.openvpms.component.model.lookup.Lookup)this.getState("TAS"));
        Assert.assertEquals((Object)code, (Object)editor.getCode());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        lookup = (Lookup)this.get((IMObject)lookup);
        Assert.assertEquals((Object)code, (Object)lookup.getCode());
    }

    @Test
    public void testNewInstance() {
        Lookup lookup = this.createSuburb();
        SuburbLookupEditor editor = this.createEditor(lookup);
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof SuburbLookupEditor));
        Assert.assertEquals((Object)lookup, (Object)newInstance.getObject());
    }

    @Test
    public void testFactory() {
        Lookup lookup = this.createSuburb();
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        IMObjectEditor editor = this.factory.create((IMObject)lookup, (LayoutContext)context);
        Assert.assertTrue((boolean)(editor instanceof SuburbLookupEditor));
    }

    private SuburbLookupEditor createEditor(Lookup suburb) {
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        return new SuburbLookupEditor((org.openvpms.component.model.lookup.Lookup)suburb, null, (LayoutContext)context);
    }

    private Lookup createSuburb() {
        return (Lookup)this.create("lookup.suburb", Lookup.class);
    }

    private Lookup getState(String code) {
        return (Lookup)this.lookupFactory.getLookup("lookup.state", code);
    }
}

