/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.laboratory;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryTestBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditorTest;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.workspace.admin.laboratory.TestEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class TestEditorTestCase
extends AbstractIMObjectEditorTest<TestEditor> {
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestUserFactory userFactory;

    public TestEditorTestCase() {
        super(TestEditor.class, "entity.laboratoryTest");
    }

    @Test
    public void testEditable() {
        Entity test1 = (Entity)this.laboratoryFactory.newTest().build(false);
        TestEditor editor1 = (TestEditor)this.newEditor((IMObject)test1);
        editor1.getComponent();
        this.checkEditable(editor1, true);
        Entity test2 = (Entity)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().code("entityIdentity.laboratoryTest", "AB1234")).build(false);
        TestEditor editor2 = (TestEditor)this.newEditor((IMObject)test2);
        editor2.getComponent();
        this.checkEditable(editor2, false);
    }

    @Test
    public void testValidateInvestigationType() {
        Entity test1 = (Entity)this.laboratoryFactory.newTest().build(false);
        TestEditor editor1 = (TestEditor)this.newEditor((IMObject)test1);
        editor1.getComponent();
        EditorTestHelper.assertInvalid((Modifiable)editor1, (String)"Investigation Type is required");
        this.checkEditable(editor1, true);
        Entity investigationType1 = this.laboratoryFactory.createInvestigationType();
        editor1.setInvestigationType(investigationType1);
        EditorTestHelper.assertValid((Modifiable)editor1);
        Entity test2 = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().code("entityIdentity.laboratoryTest", "AB1234")).investigationType(this.laboratoryFactory.createInvestigationType())).build(false);
        TestEditor editor2 = (TestEditor)this.newEditor((IMObject)test2);
        editor2.getComponent();
        this.checkEditable(editor2, false);
        EditorTestHelper.assertValid((Modifiable)editor2);
        Entity test3 = (Entity)this.laboratoryFactory.newTest().build(false);
        Entity investigationType3 = (Entity)this.laboratoryFactory.newInvestigationType().typeId("ATYPEID").build();
        TestEditor editor3 = (TestEditor)this.newEditor((IMObject)test3);
        editor3.getComponent();
        editor3.setInvestigationType(investigationType3);
        EditorTestHelper.assertInvalid((Modifiable)editor3, (String)(investigationType3.getName() + " is managed by a laboratory service, and cannot be assigned to this Test"));
        Entity test4 = (Entity)this.laboratoryFactory.newTest().build(false);
        Entity laboratory4 = this.laboratoryFactory.createHL7Laboratory(this.practiceFactory.createLocation(), this.userFactory.createUser());
        Entity investigationType4 = (Entity)this.laboratoryFactory.newInvestigationType().laboratory(laboratory4).build();
        TestEditor editor4 = (TestEditor)this.newEditor((IMObject)test4);
        editor4.getComponent();
        editor4.setInvestigationType(investigationType4);
        EditorTestHelper.assertInvalid((Modifiable)editor4, (String)(investigationType4.getName() + " has " + laboratory4.getName() + " as its Laboratory and cannot be assigned to this Test"));
    }

    private void checkEditable(TestEditor editor, boolean canEdit) {
        Assert.assertFalse((boolean)editor.canEdit("code"));
        Assert.assertFalse((boolean)editor.canEdit("group"));
        Assert.assertFalse((boolean)editor.canEdit("useDevice"));
        Assert.assertEquals((Object)canEdit, (Object)editor.canEdit("name"));
        Assert.assertEquals((Object)canEdit, (Object)editor.canEdit("description"));
        Assert.assertEquals((Object)canEdit, (Object)editor.canEdit("turnaround"));
        Assert.assertEquals((Object)canEdit, (Object)editor.canEdit("specimen"));
    }
}

