/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.customer.CustomerQuery;
import org.openvpms.web.component.im.doc.DocumentTemplateQuery;
import org.openvpms.web.component.im.patient.PatientQuery;
import org.openvpms.web.component.im.product.ProductQuery;
import org.openvpms.web.component.im.query.DefaultQuery;
import org.openvpms.web.component.im.query.EntityQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.supplier.vet.VetQuery;

public class QueryFactoryTestCase
extends AbstractAppTest {
    @Test
    public void testDefaultQuery() {
        this.checkCreate("lookup.*", DefaultQuery.class, Lookup.class);
    }

    @Test
    public void testCustomerQuery() {
        this.checkCreate("party.customer*", CustomerQuery.class, Party.class);
    }

    @Test
    public void testPatientQuery() {
        this.checkCreate("party.patient*", PatientQuery.class, Party.class);
    }

    @Test
    public void testOrganisationQuery() {
        String[] shortNames;
        this.checkCreate("party.organisationOTC", CustomerQuery.class, Party.class);
        for (String shortName : shortNames = DescriptorHelper.getShortNames((String)"party.organisationOTC", (ArchetypeService)this.getArchetypeService())) {
            if (shortName.equals("party.organisationOTC")) {
                this.checkCreate(shortName, CustomerQuery.class, Party.class);
                continue;
            }
            this.checkCreate(shortName, EntityQuery.class, Party.class);
        }
    }

    @Test
    public void testDocumentTemplate() {
        this.checkCreate("entity.documentTemplate", DocumentTemplateQuery.class, Entity.class);
    }

    @Test
    public void testSupplierEntityQuery() {
        String[] shortNames;
        for (String shortName : shortNames = DescriptorHelper.getShortNames((String)"party.supplier*", (ArchetypeService)this.getArchetypeService())) {
            if (shortName.equals("party.supplierVeterinarian")) {
                this.checkCreate(shortName, VetQuery.class, org.openvpms.component.business.domain.im.party.Party.class);
                continue;
            }
            this.checkCreate(shortName, EntityQuery.class, org.openvpms.component.business.domain.im.party.Party.class);
        }
    }

    @Test
    public void testProductQuery() {
        this.checkCreate("product.*", ProductQuery.class, Product.class);
    }

    private void checkCreate(String shortName, Class type, Class resultType) {
        String[] shortNames = new String[]{shortName};
        LocalContext context = new LocalContext();
        Query query = QueryFactory.create((String[])shortNames, (Context)context, (Class)resultType);
        Assert.assertNotNull((String)"Failed to create Query", (Object)query);
        Assert.assertEquals((Object)type, query.getClass());
        Assert.assertEquals((Object)resultType, (Object)query.getType());
    }
}

