/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.act;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientHistoryChanges;
import org.openvpms.archetype.rules.supplier.SupplierTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetBuilder;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.charge.ChargeItemRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.ChargeSaveContext;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.springframework.transaction.support.TransactionTemplate;

public class ActRelationshipCollectionEditorTestCase
extends AbstractAppTest {
    @Test
    public void testAddRelationship() {
        FinancialAct invoice = this.createInvoice();
        ActRelationshipCollectionEditor itemsEditor = this.createActRelationshipCollectionEditor(invoice, 0);
        itemsEditor.add();
        CustomerChargeActItemEditor editor1 = (CustomerChargeActItemEditor)itemsEditor.getCurrentEditor();
        Assert.assertNotNull((Object)editor1);
        editor1.setEditorQueue(null);
        Product product = TestHelper.createProduct();
        Party patient = TestHelper.createPatient();
        editor1.setProduct(product);
        editor1.setPatient(patient);
        this.save(invoice, itemsEditor);
        this.checkItems(invoice, 1);
        itemsEditor.add();
        CustomerChargeActItemEditor editor2 = (CustomerChargeActItemEditor)itemsEditor.getCurrentEditor();
        Assert.assertNotNull((Object)editor2);
        editor2.setProduct(product);
        editor2.setPatient(patient);
        this.save(invoice, itemsEditor);
        this.checkItems(invoice, 2);
    }

    @Test
    public void testExcludeDefaultItemsForMinCardinalityZero() {
        FinancialAct invoice = this.createInvoice();
        ActRelationshipCollectionEditor editor = this.createActRelationshipCollectionEditor(invoice, 0);
        editor.add();
        Assert.assertTrue((boolean)editor.isValid());
        this.save(invoice, editor);
        this.checkItems(invoice, 0);
    }

    @Test
    public void testDisableExcludeDefaultItemsForMinCardinalityZero() {
        FinancialAct invoice = this.createInvoice();
        ActRelationshipCollectionEditor editor = this.createActRelationshipCollectionEditor(invoice, 0);
        editor.setExcludeDefaultValueObject(false);
        editor.add();
        Assert.assertFalse((boolean)editor.isValid());
    }

    @Test
    public void testIncludeDefaultItemsForMinCardinalityOne() {
        FinancialAct delivery1 = this.createDelivery();
        ActRelationshipCollectionEditor editor1 = this.createActRelationshipCollectionEditor(delivery1, 1);
        editor1.getComponent();
        editor1.add();
        this.save(delivery1, editor1);
        this.checkItems(delivery1, 1);
        FinancialAct delivery2 = this.createDelivery();
        ActRelationshipCollectionEditor editor2 = this.createActRelationshipCollectionEditor(delivery2, 1);
        editor2.getComponent();
        editor2.add();
        FinancialAct first = (FinancialAct)editor2.getCurrentEditor().getObject();
        editor2.add();
        FinancialAct second = (FinancialAct)editor2.getCurrentEditor().getObject();
        this.save(delivery2, editor2);
        List<FinancialAct> items = this.checkItems(delivery2, 1);
        Assert.assertTrue((boolean)items.contains(first));
        Assert.assertFalse((boolean)items.contains(second));
    }

    @Test
    public void testTemplateExpansionForTemplateWithNoIncludes() {
        FinancialAct invoice = this.createInvoice();
        ActRelationshipCollectionEditor itemsEditor = this.createActRelationshipCollectionEditor(invoice, 0);
        itemsEditor.setExcludeDefaultValueObject(false);
        itemsEditor.add();
        CustomerChargeActItemEditor editor = (CustomerChargeActItemEditor)itemsEditor.getCurrentEditor();
        Assert.assertNotNull((Object)editor);
        Party patient = TestHelper.createPatient();
        Product product = TestHelper.createProduct((String)"product.template", null);
        editor.setPatient(patient);
        editor.setProduct(product);
        Assert.assertFalse((boolean)itemsEditor.isValid());
        Assert.assertNull((Object)editor.getProductRef());
        Assert.assertNull((Object)editor.getTemplateRef());
    }

    private List<FinancialAct> checkItems(FinancialAct parent, int expected) {
        FinancialAct reloaded = (FinancialAct)this.get((IMObject)parent);
        Assert.assertNotNull((Object)reloaded);
        IMObjectBean bean = this.getBean((IMObject)reloaded);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)expected, (long)items.size());
        return items;
    }

    private void save(FinancialAct parent, ActRelationshipCollectionEditor itemsEditor) {
        Assert.assertTrue((boolean)itemsEditor.isValid());
        TransactionTemplate template = new TransactionTemplate(ServiceHelper.getTransactionManager());
        Boolean result = (Boolean)template.execute(status -> {
            ChargeSaveContext context = null;
            if (itemsEditor instanceof ChargeItemRelationshipCollectionEditor) {
                PatientHistoryChanges changes = new PatientHistoryChanges((Reference)null, (ArchetypeService)this.getArchetypeService());
                context = ((ChargeItemRelationshipCollectionEditor)itemsEditor).getSaveContext();
                Assert.assertNotNull((Object)context);
                context.setHistoryChanges(changes);
            }
            boolean saved = SaveHelper.save((IMObject)parent);
            itemsEditor.save();
            if (context != null) {
                if (saved) {
                    context.save();
                }
                context.setHistoryChanges(null);
            }
            return saved;
        });
        Assert.assertTrue((result != null && result != false ? 1 : 0) != 0);
    }

    private ActRelationshipCollectionEditor createActRelationshipCollectionEditor(FinancialAct parent, int minCardinality) {
        User user = TestHelper.createUser();
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        context.setEdit(true);
        context.getContext().setPractice(TestHelper.getPractice());
        context.getContext().setUser(user);
        PropertySet set = new PropertySetBuilder((IMObject)parent, (LayoutContext)context).build();
        CollectionProperty items = (CollectionProperty)set.get("items");
        Assert.assertNotNull((Object)items);
        Assert.assertEquals((long)minCardinality, (long)items.getMinCardinality());
        Object result = TypeHelper.isA((IMObject)parent, (String)"act.customerAccountChargesInvoice") ? new ChargeItemRelationshipCollectionEditor(items, (Act)parent, (LayoutContext)context) : new ActRelationshipCollectionEditor(items, (Act)parent, (LayoutContext)context);
        result.getComponent();
        return result;
    }

    private FinancialAct createInvoice() {
        FinancialAct invoice = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)invoice);
        Party customer = TestHelper.createCustomer();
        Party location = TestHelper.createLocation();
        bean.setTarget("customer", (IMObject)customer);
        bean.setTarget("location", (IMObject)location);
        return invoice;
    }

    private FinancialAct createDelivery() {
        FinancialAct delivery = (FinancialAct)this.create("act.supplierDelivery", FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)delivery);
        Party supplier = TestHelper.createSupplier();
        Party stockLocation = SupplierTestHelper.createStockLocation();
        bean.setTarget("supplier", (IMObject)supplier);
        bean.setTarget("stockLocation", (IMObject)stockLocation);
        return delivery;
    }
}

