/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditDialogFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActEditDialog;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.charge.DefaultCustomerChargeActEditDialog;
import org.openvpms.web.workspace.customer.credit.CreditActEditDialog;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditDialog;
import org.openvpms.web.workspace.patient.mr.PatientClinicalEventEditDialog;

public class EditDialogFactoryTestCase
extends AbstractAppTest {
    @Test
    public void testCreateDefaultDialog() {
        this.checkCreate("contact.phoneNumber", EditDialog.class);
    }

    @Test
    public void testCustomerChargeActEditDialog() {
        this.checkCreate("act.customerAccountChargesInvoice", DefaultCustomerChargeActEditDialog.class);
    }

    @Test
    public void testCreateActEditDialog() {
        this.checkCreate("act.customerAccountChargesCounter", ActEditDialog.class);
        this.checkCreate("act.customerAccountDebitAdjust", ActEditDialog.class);
        this.checkCreate("act.customerAccountRefund", CustomerPaymentEditDialog.class);
        this.checkCreate("act.customerAccountInitialBalance", ActEditDialog.class);
    }

    public void testCreatePatientClinicalEventEditDialog() {
        this.checkCreate("act.patientClinicalEvent", PatientClinicalEventEditDialog.class);
    }

    @Test
    public void testCreateCreditActEditDialog() {
        this.checkCreate("act.customerAccountBadDebt", CreditActEditDialog.class);
        this.checkCreate("act.customerAccountChargesCredit", CreditActEditDialog.class);
        this.checkCreate("act.customerAccountCreditAdjust", CreditActEditDialog.class);
        this.checkCreate("act.customerAccountPayment", CustomerPaymentEditDialog.class);
    }

    private void checkCreate(String shortName, Class<?> type) {
        HelpContext help = new HelpContext("dummy", context -> {});
        LocalContext local = new LocalContext();
        local.setPractice(TestHelper.getPractice());
        local.setLocation(TestHelper.createLocation());
        local.setCustomer(TestHelper.createCustomer());
        DefaultLayoutContext context2 = new DefaultLayoutContext((Context)local, help);
        context2.setEdit(true);
        IMObject object = this.create(shortName);
        Assert.assertNotNull((String)("Failed to create object with shortname=" + shortName), (Object)object);
        IMObjectEditor editor = context2.getEditorFactory().create(object, (LayoutContext)context2);
        Assert.assertNotNull((String)("Failed to create editor for shortname=" + shortName), (Object)editor);
        EditDialog dialog = ((EditDialogFactory)ServiceHelper.getBean(EditDialogFactory.class)).create(editor, context2.getContext());
        Assert.assertEquals((String)("Incorrect dialog type for shortname=" + shortName), type, dialog.getClass());
    }
}

