/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.workspace.reporting.charge;

import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.workspace.reporting.account.AccountActQuery;

/**
 * Charges query.
 *
 * @author Tim Anderson
 */
public abstract class AbstractChargesQuery extends AccountActQuery {

    /**
     * The act short names.
     */
    static final String[] ARCHETYPES = {CustomerAccountArchetypes.INVOICE, CustomerAccountArchetypes.CREDIT,
                                        CustomerAccountArchetypes.COUNTER};

    /**
     * Constructs an {@link AbstractChargesQuery}.
     *
     * @param statuses the statuses to query
     * @param location the initial location to filter on. May be {@code null}
     * @param context  the layout context
     */
    public AbstractChargesQuery(ActStatuses statuses, Party location, boolean searchFilter, boolean amountFilter,
                                LayoutContext context) {
        super(ARCHETYPES, statuses, location, searchFilter, true, amountFilter, context);
    }
}
