/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.workspace.customer.payment;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DefaultDescriptorTableModel;

/**
 * Payment processor transaction table model.
 *
 * @author Tim Anderson
 */
public class PaymentProcessorTransactionTableModel extends DefaultDescriptorTableModel<Act> {

    /**
     * Constructs an {@link PaymentProcessorTransactionTableModel}.
     *
     * @param archetypes the archetypes. May contain wildcards
     * @param context    the layout context
     */
    public PaymentProcessorTransactionTableModel(String[] archetypes, LayoutContext context) {
        super(archetypes, context, ArchetypeNodes.nodes("startTime", "status", "transactionId", "amount"));
    }

    /**
     * Returns the default sort column.
     *
     * @return the default sort column, or {@code -1} if there is no default.
     */
    @Override
    public int getDefaultSortColumn() {
        return 0;
    }

    /**
     * Returns the sort criteria.
     *
     * @param column    the primary sort column
     * @param ascending if {@code true} sort in ascending order; otherwise sort in {@code descending} order
     * @return the sort criteria, or {@code null} if the column isn't sortable
     */
    @Override
    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        if (column == 0) {
            return new SortConstraint[]{new NodeSortConstraint("startTime", false)};
        }
        return super.getSortConstraints(column, ascending);
    }
}