/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2025 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.workspace.customer.payment;

import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.contact.ContactHelper;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.mail.EditableAddressSelector;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;

import java.util.List;

/**
 * Layout strategy for <em>act.customerAccountPaymentPP</em> and <em>act.customerAccountRefundPP</em> acts.
 *
 * @author Tim Anderson
 */
public class PaymentProcessorPaymentItemLayoutStrategy extends TransactionPaymentLayoutStrategy {

    /**
     * Constructs an {@link PaymentProcessorPaymentItemLayoutStrategy}.
     */
    public PaymentProcessorPaymentItemLayoutStrategy() {
        super();
    }

    /**
     * Apply the layout strategy.
     * <p>
     * This renders an object in a {@code Component}, using a factory to create the child components.
     *
     * @param object     the object to apply
     * @param properties the object's properties
     * @param parent     the parent object. May be {@code null}
     * @param context    the layout context
     * @return the component containing the rendered {@code object}
     */
    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        if (context.isEdit()) {
            Property email = properties.get("email");
            if (email.isEditable()) {
                Party customer = context.getCache().get(getBean(parent).getTargetRef("customer"), Party.class);
                if (customer != null) {
                    List<Contact> contacts = ContactHelper.getEmailContacts(customer, getService());
                    EditableAddressSelector selector = new EditableAddressSelector(email, contacts);
                    if (email.getString() == null && contacts.size() == 1) {
                        selector.setSelected(contacts.get(0));
                    }
                    addComponent(new ComponentState(selector.getComponent(), email));
                }
            }
            getArchetypeNodes().exclude("paymentProcessor");
        } else {
            getArchetypeNodes().excludeIfEmpty("description", "email");
        }
        return super.apply(object, properties, parent, context);
    }
}