/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.DefaultIMObjectTableBrowser;
import org.openvpms.web.component.im.query.EntityObjectSetQuery;
import org.openvpms.web.component.im.query.EntityObjectSetResultSet;
import org.openvpms.web.component.im.query.EntityQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workflow.DefaultTaskContext;
import org.openvpms.web.component.workflow.EditIMObjectTask;
import org.openvpms.web.component.workflow.PrintActTask;
import org.openvpms.web.component.workflow.PrintIMObjectTask;
import org.openvpms.web.component.workflow.SelectIMObjectTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.WorkflowImpl;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.workflow.checkin.AbstractPrintPatientDocumentsTask;
import org.openvpms.web.workspace.workflow.checkin.AddFlowSheetTask;
import org.openvpms.web.workspace.workflow.checkin.PrintPatientActTask;
import org.openvpms.web.workspace.workflow.worklist.TaskActEditor;

public class TransferWorkflow
extends WorkflowImpl {
    private final TaskContext initial;

    public TransferWorkflow(Act task, Context context, HelpContext help) {
        super(help);
        IMObjectBean bean = this.getBean((IMObject)task);
        Party customer = (Party)bean.getTarget("customer", Party.class);
        Party patient = (Party)bean.getTarget("patient", Party.class);
        Party location = context.getLocation();
        Reference workList = bean.getTargetRef("worklist");
        context = LocalContext.copy((Context)context);
        context.setTask(task);
        context.setCustomer(customer);
        context.setPatient(patient);
        context.setLocation(location);
        context.setObject("act.patientClinicalEvent", null);
        this.initial = new DefaultTaskContext(context, help);
        WorkListQuery workListQuery = new WorkListQuery(workList, context.getLocation(), context.getPractice());
        EntityQuery query = new EntityQuery((EntityObjectSetQuery)workListQuery, (Context)this.initial);
        this.addTask((Task)new SelectIMObjectTask<Party>((Query)query, help.topic("worklist")){

            protected Browser<Party> createBrowser(Query<Party> query, LayoutContext layout) {
                return new DefaultIMObjectTableBrowser(query, layout);
            }
        });
        this.addTask((Task)new UpdateWorkListTask(task));
        FlowSheetServiceFactory factory = (FlowSheetServiceFactory)ServiceHelper.getBean(FlowSheetServiceFactory.class);
        if (factory.isSmartFlowSheetEnabled(location)) {
            this.addTask((Task)new AddFlowSheetTask(task, factory, help));
        }
        this.addTask((Task)new PrintPatientDocumentsTask(this.getHelpContext()));
    }

    public void start() {
        super.start(this.initial);
    }

    private static class WorkListQuery
    extends EntityObjectSetQuery {
        private final Reference exclude;
        private final Party location;
        private final CheckBox allLocations;
        private static final String[] SHORT_NAMES = new String[]{"party.organisationWorkList"};

        public WorkListQuery(Reference exclude, Party location, Party practice) {
            super(SHORT_NAMES);
            this.exclude = exclude;
            this.setAuto(true);
            IMObjectBean bean = IMObjectHelper.getBean((IMObject)practice);
            if (location != null && bean.getTargetRefs("locations").size() > 1) {
                this.location = location;
                this.allLocations = CheckBoxFactory.create();
                this.allLocations.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                    public void onAction(ActionEvent event) {
                        this.onQuery();
                    }
                });
            } else {
                this.location = null;
                this.allLocations = null;
            }
        }

        protected void doLayout(Component container) {
            super.doLayout(container);
            if (this.allLocations != null) {
                container.add((Component)LabelFactory.create((String)"location.all"));
                container.add((Component)this.allLocations);
            }
        }

        protected ResultSet<ObjectSet> createResultSet(SortConstraint[] sort) {
            return new EntityObjectSetResultSet(this.getArchetypeConstraint(), this.getValue(), this.isIdentitySearch(), sort, this.getMaxResults(), this.isDistinct()){

                protected ArchetypeQuery createQuery() {
                    Party restrictToLocation;
                    ArchetypeQuery query = super.createQuery();
                    if (exclude != null) {
                        query.add((IConstraint)Constraints.not((IConstraint)new ObjectRefConstraint("entity", exclude)));
                    }
                    if ((restrictToLocation = this.getLocation()) != null) {
                        query.add((IConstraint)Constraints.exists((ArchetypeQuery)Constraints.subQuery((String)"party.organisationLocation", (String)"location").add((IConstraint)Constraints.eq((String)"id", (Object)restrictToLocation.getId())).add((IConstraint)Constraints.join((String)"workListViews").add((IConstraint)Constraints.join((String)"target", (String)"workListView").add((IConstraint)Constraints.join((String)"workListView.workLists", (String)"w").add((IConstraint)Constraints.idEq((String)"entity", (String)"w.target")))))));
                    }
                    return query;
                }
            };
        }

        private Party getLocation() {
            Party result = null;
            if (this.allLocations != null && !this.allLocations.isSelected()) {
                result = this.location;
            }
            return result;
        }
    }

    private static class PrintTask
    extends PrintPatientActTask {
        public PrintTask(Act act, MailContext context, PrintIMObjectTask.PrintMode printMode) {
            super(act, context, printMode);
        }

        @Override
        protected Act getEvent(Act document, TaskContext context) {
            IMObjectBean bean;
            Reference patient;
            Act event = super.getEvent(document, context);
            if (event == null && (patient = (bean = this.getBean((IMObject)document)).getTargetRef("patient")) != null) {
                MedicalRecordRules rules = (MedicalRecordRules)ServiceHelper.getBean(MedicalRecordRules.class);
                event = rules.getEvent(patient, document.getActivityStartTime(), context.getLocation().getObjectReference());
            }
            return event;
        }
    }

    private static class PrintPatientDocumentsTask
    extends AbstractPrintPatientDocumentsTask {
        public PrintPatientDocumentsTask(HelpContext help) {
            super(PrintIMObjectTask.PrintMode.DEFAULT, help);
            this.setRequired(false);
        }

        @Override
        protected boolean canCancel() {
            return false;
        }

        @Override
        protected Entity getWorkList(TaskContext context) {
            return context.getWorkList();
        }

        @Override
        protected Entity getSchedule(TaskContext context) {
            return null;
        }

        @Override
        protected PrintActTask createPrintTask(Act document, CustomerMailContext mailContext, PrintIMObjectTask.PrintMode printMode) {
            return new PrintTask(document, (MailContext)mailContext, printMode);
        }
    }

    private static class UpdateWorkListTask
    extends EditIMObjectTask {
        public UpdateWorkListTask(Act act) {
            super((IMObject)act, false);
        }

        protected void edit(IMObjectEditor editor, TaskContext context) {
            super.edit(editor, context);
            if (editor instanceof TaskActEditor) {
                ((TaskActEditor)editor).setWorkList(context.getWorkList());
            }
        }
    }
}

