/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.table.DefaultTableHeaderRenderer;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;
import org.openvpms.web.workspace.workflow.worklist.TaskGrid;
import org.openvpms.web.workspace.workflow.worklist.TaskTableCellRenderer;
import org.openvpms.web.workspace.workflow.worklist.TaskTableModel;

public class SingleScheduleTaskTableModel
extends TaskTableModel {
    private String[] columnNames;
    private static final int START_TIME_INDEX = 0;
    private static final int STATUS_INDEX = 1;
    private static final int TASK_TYPE_INDEX = 2;
    private static final int CUSTOMER_INDEX = 3;
    private static final int PATIENT_INDEX = 4;
    private static final int NOTES_INDEX = 5;
    private static final int ELAPSED_TIME_INDEX = 6;
    private static final String[] NODE_NAMES = new String[]{"startTime", "status", "taskType", "customer", "patient", "notes"};

    public SingleScheduleTaskTableModel(TaskGrid grid, Context context, ScheduleColours colours) {
        super(grid, context, colours);
    }

    public Object getValueAt(int column, int row) {
        Object result = null;
        PropertySet set = this.getEvent(column, row);
        if (set != null) {
            result = this.getValue(set, (ScheduleTableModel.ScheduleColumn)this.getColumn(column));
        }
        return result;
    }

    @Override
    protected TableColumnModel createColumnModel(ScheduleEventGrid grid) {
        DefaultTableColumnModel result = new DefaultTableColumnModel();
        List<Schedule> schedules = grid.getSchedules();
        Schedule schedule = schedules.get(0);
        String[] names = this.getColumnNames();
        TaskTableCellRenderer renderer = new TaskTableCellRenderer(this);
        for (int i = 0; i < names.length; ++i) {
            ScheduleTableModel.ScheduleColumn column = new ScheduleTableModel.ScheduleColumn(i, schedule, names[i]);
            column.setCellRenderer((TableCellRenderer)renderer);
            column.setHeaderRenderer(DefaultTableHeaderRenderer.DEFAULT);
            result.addColumn((TableColumn)column);
        }
        return result;
    }

    private Object getValue(PropertySet set, ScheduleTableModel.ScheduleColumn column) {
        String result = null;
        int index = column.getModelIndex();
        switch (index) {
            case 0: {
                Date startTime = set.getDate("act.startTime");
                Label label = LabelFactory.create();
                label.setText(DateFormatter.formatDateTimeAbbrev((Date)startTime));
                result = label;
                break;
            }
            case 1: {
                result = this.getStatus(set);
                break;
            }
            case 5: {
                result = LabelFactory.text((String)set.getString("notes"));
                break;
            }
            case 2: {
                result = this.getViewer(set, "scheduleType.objectReference", "scheduleType.name", false);
                break;
            }
            case 3: {
                result = this.getViewer(set, "customer.objectReference", "customer.name", true);
                break;
            }
            case 4: {
                result = this.getViewer(set, "patient.objectReference", "patient.name", true);
                break;
            }
            case 6: {
                Date start = set.getDate("act.startTime");
                Date end = set.getDate("act.endTime");
                if (start == null) break;
                if (end == null) {
                    end = new Date();
                }
                result = DateFormatter.formatTimeDiff((Date)start, (Date)end);
            }
        }
        return result;
    }

    private String[] getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new String[NODE_NAMES.length + 1];
            ArchetypeDescriptor archetype = ServiceHelper.getArchetypeService().getArchetypeDescriptor("act.customerTask");
            if (archetype != null) {
                for (int i = 0; i < NODE_NAMES.length; ++i) {
                    NodeDescriptor descriptor = archetype.getNodeDescriptor(NODE_NAMES[i]);
                    if (descriptor == null) continue;
                    this.columnNames[i] = descriptor.getDisplayName();
                }
            }
            this.columnNames[6] = Messages.get((String)"table.act.time");
        }
        return this.columnNames;
    }
}

