/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractEntityQuery;
import org.openvpms.web.component.im.query.FilteredResultSet;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.util.IMObjectSorter;

class RestrictedWorkListQuery
extends AbstractEntityQuery<Entity> {
    private final List<Entity> workLists;

    public RestrictedWorkListQuery(List<Entity> workLists) {
        super(new String[]{"party.organisationWorkList"}, Entity.class);
        this.setAuto(true);
        this.setContains(true);
        this.workLists = workLists;
        this.setDefaultSortConstraint(null);
    }

    protected ResultSet<Entity> createResultSet(SortConstraint[] sort) {
        String value = this.getValue();
        final Pattern pattern = !StringUtils.isEmpty((CharSequence)value) ? QueryHelper.getWildcardPattern((String)value) : null;
        WorklistResultSet set = new WorklistResultSet(this.workLists, this.getMaxResults());
        if (pattern != null) {
            set = new FilteredResultSet<Entity>((ResultSet)set){

                protected void filter(Entity object, List<Entity> results) {
                    String name = object.getName();
                    if (name != null && pattern.matcher(name).matches()) {
                        results.add(object);
                    }
                }
            };
        }
        if (sort != null) {
            set.sort(sort);
        }
        return set;
    }

    public boolean selects(Reference reference) {
        return QueryHelper.selects((ResultSet)this.query(), (Reference)reference);
    }

    private static class WorklistResultSet
    extends ListResultSet<Entity> {
        WorklistResultSet(List<Entity> objects, int pageSize) {
            super(objects, pageSize);
        }

        public void sort(SortConstraint[] sort) {
            super.sort(sort);
            IMObjectSorter.sort((List)this.getObjects(), (SortConstraint[])sort, input -> input);
        }
    }
}

