/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling.view;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.DateRangeActQuery;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.resource.i18n.Messages;

public abstract class ParticipantScheduleEventQuery
extends DateRangeActQuery<Act> {
    public static final String INCOMPLETE = "INCOMPLETE";
    private final String[] COMPLETE_STATUSES = new String[]{"COMPLETED", "CANCELLED"};
    protected static final Lookup INCOMPLETE_STATUS = new Lookup(new ArchetypeId("lookup.local"), "INCOMPLETE", Messages.get((String)"workflow.scheduling.appointment.view.incomplete"));

    public ParticipantScheduleEventQuery(Entity entity, String participant, String participation, String archetype, ActStatuses statuses) {
        super(entity, participant, participation, new String[]{archetype}, statuses, Act.class);
    }

    protected String[] getCompletedStatuses() {
        return this.COMPLETE_STATUSES;
    }

    protected ResultSet<Act> createResultSet(SortConstraint[] sort) {
        String[] statuses;
        org.openvpms.component.model.lookup.Lookup selected = this.getStatusSelector().getSelected();
        if (selected == INCOMPLETE_STATUS) {
            ArrayList available = new ArrayList(this.getStatusLookups().getCodes());
            for (String status : this.getCompletedStatuses()) {
                available.remove(status);
            }
            statuses = available.toArray(new String[0]);
        } else {
            statuses = super.getStatuses();
        }
        return new ActResultSet(this.getArchetypeConstraint(), this.getParticipantConstraint(), this.getFrom(), this.getTo(), statuses, this.excludeStatuses(), this.getConstraints(), this.getMaxResults(), sort);
    }

    protected static class StatusLookupQuery
    extends NodeLookupQuery {
        public StatusLookupQuery(String archetype) {
            super(archetype, "status");
        }

        public org.openvpms.component.model.lookup.Lookup getDefault() {
            return INCOMPLETE_STATUS;
        }

        public List<org.openvpms.component.model.lookup.Lookup> getLookups() {
            List lookups = super.getLookups();
            lookups.add(0, INCOMPLETE_STATUS);
            return lookups;
        }
    }
}

