/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import echopointng.GroupBox;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.property.DefaultPropertyComponentFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyComponentFactory;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.GroupBoxFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.text.TextHelper;
import org.openvpms.web.workspace.workflow.scheduling.SchedulingHelper;

public class ScheduleViewExpressionEditor {
    private final Property expression;
    private final List<Property> properties;
    private final Component component;

    public ScheduleViewExpressionEditor(Property expression, boolean scheduleView) {
        this.expression = expression;
        this.properties = this.createProperties(scheduleView);
        PropertyComponentFactory factory = DefaultPropertyComponentFactory.INSTANCE;
        Label propertyName = LabelFactory.create();
        propertyName.setText(expression.getDisplayName());
        Component editor = factory.create(expression);
        Label help = LabelFactory.create((String)"scheduleview.expression.help", (boolean)true);
        Grid expressionGrid = GridFactory.create((int)2, (Component[])new Component[]{propertyName, editor, LabelFactory.create(), help});
        Grid propertyGrid = GridFactory.create((int)2);
        for (Property property : this.properties) {
            if (!property.isBoolean() && !property.isString() && !property.isNumeric() && !property.isDate()) continue;
            Component component = factory.create(property);
            Label label = LabelFactory.create();
            label.setText(property.getDisplayName());
            propertyGrid.add((Component)label);
            propertyGrid.add(component);
        }
        GroupBox box = GroupBoxFactory.create((String)"scheduleview.expression.properties", (Component[])new Component[]{propertyGrid});
        this.component = ColumnFactory.create((String)"Inset", (Component[])new Component[]{ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{expressionGrid, box})});
    }

    public Component getComponent() {
        return this.component;
    }

    public void test() {
        try {
            String result = this.evaluate();
            InformationDialog.show((String)this.getDisplayName(), (String)result);
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception, (boolean)false);
        }
    }

    public String evaluate() {
        String expr;
        Object value = this.expression.getValue();
        String string = expr = value != null ? value.toString() : null;
        if (expr != null) {
            ObjectSet set = new ObjectSet();
            for (Property property : this.properties) {
                set.set(property.getName(), property.getValue());
            }
            return SchedulingHelper.evaluate(expr, (PropertySet)set);
        }
        return null;
    }

    public String getDisplayName() {
        return this.expression.getDisplayName();
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    private List<Property> createProperties(boolean scheduleView) {
        ArrayList<Property> result = new ArrayList<Property>();
        String shortName = scheduleView ? "act.customerAppointment" : "act.customerTask";
        IMObjectReference reference = new IMObjectReference(shortName, -1L);
        result.add(this.create("act.objectReference", reference));
        result.add(this.create("act.startTime", new Date()));
        result.add(this.create("act.endTime", new Date()));
        result.add(this.create("act.status"));
        result.add(this.create("act.statusName"));
        result.add(this.create("act.reason"));
        result.add(this.create("act.reasonName"));
        result.add(this.create("customer.name"));
        result.add(this.create("patient.name"));
        result.add(this.create("clinician.name"));
        result.add(this.create("schedule.name"));
        result.add(this.create("scheduleType.name"));
        result.add(this.create("notes"));
        if (scheduleView) {
            result.add(this.create("confirmedTime", new Date()));
            result.add(this.create("arrivalTime", new Date()));
        } else {
            result.add(this.create("consultStartTime", new Date()));
        }
        return result;
    }

    private Property create(String name, Object value) {
        SimpleProperty property = new SimpleProperty(name, value, value.getClass());
        property.setDisplayName(name);
        return property;
    }

    private Property create(String name) {
        String value = TextHelper.unCamelCase((String)name);
        value = value.replace('.', ' ');
        return this.create(name, value);
    }
}

