/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import echopointng.table.TableColumnEx;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.table.TableColumnModel;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.function.factory.ArchetypeFunctionsFactory;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.CachingReadOnlyArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.echo.table.AbstractCellTableModel;
import org.openvpms.web.echo.table.Cell;
import org.openvpms.web.echo.table.RenderTableModel;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;
import org.openvpms.web.workspace.workflow.scheduling.SchedulingHelper;

public abstract class ScheduleTableModel
extends AbstractCellTableModel
implements RenderTableModel {
    private final ScheduleEventGrid grid;
    private final Context context;
    private final boolean scheduleColumns;
    private final String expression;
    private final boolean displayNotes;
    private final boolean useStrikethrough;
    private final ScheduleColours colours;
    private final TableColumnModel model;
    private Reference clinician;
    private Highlight highlight = Highlight.EVENT_TYPE;
    private CachingReadOnlyArchetypeService service;
    private FunctionLibrary functions;
    private static final String USE_STRIKETHROUGH = "useStrikethrough";

    public ScheduleTableModel(ScheduleEventGrid grid, Context context, boolean scheduleColumns, ScheduleColours colours) {
        this.grid = grid;
        this.context = context;
        this.scheduleColumns = scheduleColumns;
        Entity view = grid.getScheduleView();
        if (view != null) {
            IMObjectBean bean = IMObjectHelper.getBean((IMObject)view);
            this.expression = bean.getString("displayExpression");
            this.displayNotes = bean.getBoolean("displayNotes");
            this.useStrikethrough = bean.hasNode(USE_STRIKETHROUGH) && bean.getBoolean(USE_STRIKETHROUGH);
        } else {
            this.expression = null;
            this.displayNotes = true;
            this.useStrikethrough = false;
        }
        this.colours = colours;
        this.model = this.createColumnModel(grid);
    }

    public List<Schedule> getSchedules() {
        return this.grid.getSchedules();
    }

    public Cell getCell(Reference schedule, Reference event) {
        Cell result = null;
        if (this.scheduleColumns) {
            for (ScheduleColumn column : this.getColumns(schedule)) {
                Schedule s = column.getSchedule();
                int slot = this.getSlot(s, event);
                if (slot == -1) continue;
                int row = this.getCellRow(slot);
                result = new Cell(column.getModelIndex(), row);
                break;
            }
        } else {
            for (ScheduleRow row : this.getRows(schedule)) {
                Schedule s = row.getSchedule();
                int slot = this.getSlot(s, event);
                if (slot == -1) continue;
                int column = this.getCellColumn(slot);
                result = new Cell(column, row.getRow());
                break;
            }
        }
        return result;
    }

    public Cell getCell(Reference schedule, Date date) {
        Cell result = null;
        int slot = this.grid.getSlot(date);
        if (slot != -1) {
            if (this.scheduleColumns) {
                List<ScheduleColumn> columns = this.getColumns(schedule);
                if (!columns.isEmpty()) {
                    int index = columns.get(0).getModelIndex();
                    result = new Cell(index, this.getCellRow(slot));
                }
            } else {
                List<ScheduleRow> rows = this.getRows(schedule);
                if (!rows.isEmpty()) {
                    int row = rows.get(0).getRow();
                    result = new Cell(this.getCellColumn(slot), row);
                }
            }
        }
        return result;
    }

    public abstract int getSlot(Schedule var1, Reference var2);

    public void setClinician(Reference clinician) {
        this.clinician = clinician;
        this.fireTableDataChanged();
    }

    public Reference getClinician() {
        return this.clinician;
    }

    public void setHighlight(Highlight highlight) {
        this.highlight = highlight;
        this.fireTableDataChanged();
    }

    public Highlight getHighlight() {
        return this.highlight;
    }

    public boolean useStrikeThrough() {
        return this.useStrikethrough;
    }

    public boolean isSingleScheduleView() {
        return this.getSchedules().size() == 1;
    }

    public String getColumnName(int column) {
        return this.getColumn(column).getColumnName();
    }

    public ScheduleEventGrid getGrid() {
        return this.grid;
    }

    public TableColumnModel getColumnModel() {
        return this.model;
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public int getRowCount() {
        return this.scheduleColumns ? this.grid.getSlots() : this.grid.getSchedules().size();
    }

    public PropertySet getEvent(Cell cell) {
        return this.getEvent(cell.getColumn(), cell.getRow());
    }

    public PropertySet getEvent(int column, int row) {
        int slot = this.getSlot(column, row);
        Schedule schedule = this.getSchedule(column, row);
        return schedule != null ? this.grid.getEvent(schedule, slot) : null;
    }

    public Schedule getSchedule(Cell cell) {
        return this.getSchedule(cell.getColumn(), cell.getRow());
    }

    public Schedule getSchedule(int column, int row) {
        Schedule result = null;
        if (this.scheduleColumns) {
            ScheduleColumn col = (ScheduleColumn)this.getColumn(column);
            if (col != null) {
                result = col.getSchedule();
            }
        } else if (row >= 0 && row < this.grid.getSchedules().size()) {
            result = this.grid.getSchedules().get(row);
        }
        return result;
    }

    public Entity getScheduleEntity(Cell cell) {
        return this.getScheduleEntity(cell.getColumn(), cell.getRow());
    }

    public Entity getScheduleEntity(int column, int row) {
        Schedule schedule = this.getSchedule(column, row);
        return schedule != null ? schedule.getSchedule() : null;
    }

    public ScheduleEventGrid.Availability getAvailability(Cell cell) {
        return this.getAvailability(cell.getColumn(), cell.getRow());
    }

    public ScheduleEventGrid.Availability getAvailability(int column, int row) {
        Schedule schedule = this.getSchedule(column, row);
        if (schedule == null) {
            return ScheduleEventGrid.Availability.UNAVAILABLE;
        }
        int slot = this.getSlot(column, row);
        if (slot < 0) {
            return ScheduleEventGrid.Availability.UNAVAILABLE;
        }
        return this.getAvailability(schedule, slot);
    }

    public ScheduleEventGrid.Availability getAvailability(Schedule schedule, int slot) {
        return this.grid.getAvailability(schedule, slot);
    }

    public Date getStartTime(Schedule schedule, Cell cell) {
        int slot = this.getSlot(cell.getColumn(), cell.getRow());
        return this.grid.getStartTime(schedule, slot);
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean getDisplayNotes() {
        return this.displayNotes;
    }

    public String getStatus(PropertySet event) {
        return event.getString("act.statusName");
    }

    public int getSlot(int column, int row) {
        return this.scheduleColumns ? row : column;
    }

    public State getState() {
        return new State(this);
    }

    public void setState(State state) {
        Set<Reference> schedules = State.getSchedules(this.getSchedules());
        Set<Reference> newSchedules = state.getSchedules();
        Cell newSelected = state.getSelected();
        Reference newEvent = state.getSelectedEvent();
        if (newSelected != null && schedules.equals(newSchedules)) {
            if (newSelected.getColumn() < this.getColumnCount() && newSelected.getRow() < this.getRowCount()) {
                PropertySet event;
                if (!(newEvent == null || (event = this.getEvent(newSelected)) != null && Objects.equals(newEvent, event.getReference("act.objectReference")))) {
                    newSelected = null;
                }
            } else {
                newSelected = null;
            }
        } else {
            newSelected = null;
        }
        this.setSelected(newSelected);
        Reference newMarkedEvent = state.getMarkedEvent();
        Reference newMarkedSchedule = state.getMarkedSchedule();
        Cell newMarked = null;
        if (newMarkedEvent != null && newMarkedSchedule != null) {
            newMarked = this.getCell(newMarkedSchedule, newMarkedEvent);
        }
        this.setMarked(newMarked, state.isCut());
    }

    public ScheduleColours getColours() {
        return this.colours;
    }

    public String evaluate(PropertySet event) {
        String result = null;
        String expression = this.getExpression();
        if (!StringUtils.isEmpty((CharSequence)expression)) {
            if (this.functions == null) {
                this.service = new CachingReadOnlyArchetypeService(1000, (IArchetypeService)ServiceHelper.getArchetypeService());
                this.functions = ((ArchetypeFunctionsFactory)ServiceHelper.getBean(ArchetypeFunctionsFactory.class)).create((IArchetypeService)this.service, true);
            }
            result = SchedulingHelper.evaluate(expression, event, this.functions);
        }
        return result;
    }

    public void preRender() {
    }

    public void postRender() {
        if (this.service != null) {
            this.service.clear();
        }
    }

    protected PropertySet getEvent(Schedule schedule, int slot) {
        return schedule != null ? this.grid.getEvent(schedule, slot) : null;
    }

    protected abstract TableColumnModel createColumnModel(ScheduleEventGrid var1);

    protected Component getViewer(PropertySet set, String refKey, String nameKey, boolean link) {
        IMObjectReference ref = set.getReference(refKey);
        String name = set.getString(nameKey);
        IMObjectReferenceViewer viewer = new IMObjectReferenceViewer((Reference)ref, name, link, this.context);
        return viewer.getComponent();
    }

    protected List<ScheduleColumn> getColumns() {
        ArrayList<ScheduleColumn> result = new ArrayList<ScheduleColumn>();
        Iterator iterator = this.model.getColumns();
        while (iterator.hasNext()) {
            result.add((ScheduleColumn)((Object)iterator.next()));
        }
        return result;
    }

    protected int getCellColumn(int slot) {
        return slot;
    }

    protected int getCellRow(int slot) {
        return slot;
    }

    protected Column getColumn(int column) {
        Column result = null;
        Iterator iterator = this.model.getColumns();
        while (iterator.hasNext()) {
            Column col = (Column)((Object)iterator.next());
            if (col.getModelIndex() != column) continue;
            result = col;
            break;
        }
        return result;
    }

    protected List<ScheduleRow> getRows(Reference scheduleRef) {
        ArrayList<ScheduleRow> result = new ArrayList<ScheduleRow>();
        int index = 0;
        for (Schedule schedule : this.grid.getSchedules()) {
            if (schedule.getSchedule().getId() == scheduleRef.getId()) {
                result.add(new ScheduleRow(schedule, index));
            }
            ++index;
        }
        return result;
    }

    private List<ScheduleColumn> getColumns(Reference scheduleRef) {
        ArrayList<ScheduleColumn> result = new ArrayList<ScheduleColumn>();
        for (ScheduleColumn column : this.getColumns()) {
            Entity schedule;
            if (column.getSchedule() == null || !(schedule = column.getSchedule().getSchedule()).getObjectReference().equals((Object)scheduleRef)) continue;
            result.add(column);
        }
        return result;
    }

    protected static class ScheduleRow {
        private final Schedule schedule;
        private final int row;

        public ScheduleRow(Schedule schedule, int row) {
            this.schedule = schedule;
            this.row = row;
        }

        public Schedule getSchedule() {
            return this.schedule;
        }

        public int getRow() {
            return this.row;
        }
    }

    protected static class ScheduleColumn
    extends Column {
        private final Schedule schedule;

        public ScheduleColumn(int modelIndex, Schedule schedule) {
            this(modelIndex, schedule, schedule.getName());
        }

        public ScheduleColumn(int modelIndex, Schedule schedule, String name) {
            super(modelIndex, name);
            this.schedule = schedule;
        }

        public ScheduleColumn(int modelIndex, String heading) {
            this(modelIndex, null, heading);
        }

        public Schedule getSchedule() {
            return this.schedule;
        }
    }

    protected static class Column
    extends TableColumnEx {
        private final String name;

        public Column(int modelIndex, String name) {
            super(modelIndex);
            this.name = name;
            this.setHeaderValue(name);
            this.setHeaderRenderer(null);
            this.setCellRenderer(null);
        }

        public String getColumnName() {
            return this.name;
        }
    }

    public static class State {
        private final Set<Reference> schedules;
        private final Cell selected;
        private final Reference selectedEvent;
        private final Reference markedEvent;
        private final boolean isCut;
        private final Reference markedSchedule;

        public State(ScheduleTableModel model) {
            this.schedules = State.getSchedules(model.getSchedules());
            this.selected = model.getSelected();
            this.selectedEvent = this.getEvent(model, this.selected);
            Cell markedCell = model.getMarked();
            if (markedCell != null) {
                PropertySet event = model.getEvent(markedCell);
                this.markedEvent = this.getEvent(event);
                this.markedSchedule = this.getSchedule(event);
            } else {
                this.markedEvent = null;
                this.markedSchedule = null;
            }
            this.isCut = model.isCut();
        }

        public Set<Reference> getSchedules() {
            return this.schedules;
        }

        public Cell getSelected() {
            return this.selected;
        }

        public Reference getSelectedEvent() {
            return this.selectedEvent;
        }

        public Reference getMarkedEvent() {
            return this.markedEvent;
        }

        public Reference getMarkedSchedule() {
            return this.markedSchedule;
        }

        public boolean isCut() {
            return this.isCut;
        }

        public static Set<Reference> getSchedules(List<Schedule> schedules) {
            HashSet<Reference> result = new HashSet<Reference>();
            for (Schedule schedule : schedules) {
                result.add(schedule.getSchedule().getObjectReference());
            }
            return result;
        }

        private Reference getEvent(ScheduleTableModel model, Cell cell) {
            Reference reference = null;
            if (cell != null) {
                PropertySet event = model.getEvent(cell);
                reference = this.getEvent(event);
            }
            return reference;
        }

        private Reference getEvent(PropertySet event) {
            return event != null ? event.getReference("act.objectReference") : null;
        }

        private Reference getSchedule(PropertySet event) {
            return event != null ? event.getReference("schedule.objectReference") : null;
        }
    }

    public static enum Highlight {
        EVENT_TYPE,
        CLINICIAN,
        STATUS;

    }
}

