/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.im.list.IMObjectListModel;
import org.openvpms.web.component.im.query.QueryListener;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.workspace.workflow.scheduling.Schedules;

public abstract class ScheduleQuery {
    private final Schedules schedules;
    private final List<Entity> views;
    private final Entity defaultView;
    private SelectField scheduleField;
    private ScheduleQueryListener listener;
    private SelectField viewField;
    private List<Entity> viewSchedules;
    private Component component;
    private FocusGroup focus;

    public ScheduleQuery(Schedules schedules) {
        this.schedules = schedules;
        List<Entity> views = schedules.getScheduleViews();
        if (views.size() > 1) {
            views = new ArrayList<Entity>(views);
            views.sort(IMObjectSorter.getNameComparator((boolean)true));
        }
        this.views = views;
        this.defaultView = schedules.getDefaultScheduleView(views);
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = this.createContainer();
            this.focus = new FocusGroup(this.getClass().getSimpleName());
            this.doLayout(this.component);
        }
        return this.component;
    }

    public Entity getScheduleView() {
        this.getComponent();
        return (Entity)this.viewField.getSelectedItem();
    }

    public void setScheduleView(Entity view) {
        this.getComponent();
        if (!Objects.equals(this.viewField.getSelectedItem(), view)) {
            this.viewField.setSelectedItem((Object)view);
            this.updateViewSchedules();
        }
    }

    public List<Entity> getViewSchedules() {
        Entity view;
        if (this.viewSchedules == null && (view = this.getScheduleView()) != null) {
            this.viewSchedules = this.schedules.getSchedules(view);
        }
        return this.viewSchedules != null ? this.viewSchedules : Collections.emptyList();
    }

    public Entity getSchedule() {
        return (Entity)this.scheduleField.getSelectedItem();
    }

    public List<Entity> getSelectedSchedules() {
        Entity schedule = this.getSchedule();
        return schedule != null ? Collections.singletonList(schedule) : this.getViewSchedules();
    }

    public void setSchedule(Entity schedule) {
        this.getComponent();
        if (schedule != null) {
            this.scheduleField.setSelectedItem((Object)schedule);
        } else if (this.scheduleField.getModel().size() > 0) {
            this.scheduleField.setSelectedIndex(0);
        }
    }

    public FocusGroup getFocusGroup() {
        return this.focus;
    }

    public void setListener(ScheduleQueryListener listener) {
        this.listener = listener;
    }

    protected Schedules getSchedules() {
        return this.schedules;
    }

    protected Component createContainer() {
        return GridFactory.create((int)6);
    }

    protected void doLayout(Component container) {
        this.viewField = this.createScheduleViewField();
        this.scheduleField = this.createScheduleField();
        Label scheduleLabel = LabelFactory.create();
        scheduleLabel.setText(this.schedules.getScheduleDisplayName());
        container.add((Component)LabelFactory.create((String)"workflow.scheduling.query.view"));
        container.add((Component)this.viewField);
        container.add((Component)scheduleLabel);
        container.add((Component)this.scheduleField);
        this.focus.add((Component)this.viewField);
        this.focus.add((Component)this.scheduleField);
    }

    protected void onQuery() {
        if (this.listener != null) {
            this.listener.query();
        }
    }

    protected void onNow() {
        if (this.listener != null) {
            this.listener.now();
        }
    }

    protected void onViewChanged() {
        this.updateViewSchedules();
        this.onQuery();
    }

    protected void updateViewSchedules() {
        this.viewSchedules = null;
        this.updateScheduleField();
    }

    private SelectField createScheduleViewField() {
        IMObjectListModel model = new IMObjectListModel(this.views, false, false);
        SelectField result = SelectFieldFactory.create((ListModel)model);
        result.setCellRenderer((ListCellRenderer)IMObjectListCellRenderer.NAME);
        if (this.defaultView != null) {
            result.setSelectedItem((Object)this.defaultView);
        }
        result.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                ScheduleQuery.this.onViewChanged();
            }
        });
        return result;
    }

    private SelectField createScheduleField() {
        List<Entity> viewSchedules = this.getViewSchedules();
        IMObjectListModel model = this.createScheduleModel(viewSchedules);
        SelectField result = SelectFieldFactory.create((ListModel)model);
        if (this.defaultView != null && this.defaultView.equals(this.getScheduleView())) {
            Entity schedule = this.schedules.getDefaultSchedule(this.defaultView, viewSchedules);
            if (schedule != null) {
                result.setSelectedItem((Object)schedule);
            } else {
                result.setSelectedIndex(model.getAllIndex());
            }
        }
        result.setCellRenderer((ListCellRenderer)IMObjectListCellRenderer.NAME);
        result.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                ScheduleQuery.this.onQuery();
            }
        });
        return result;
    }

    private void updateScheduleField() {
        IMObjectListModel model = this.createScheduleModel();
        this.scheduleField.setModel((ListModel)model);
        this.setSchedule(null);
    }

    private IMObjectListModel createScheduleModel() {
        return this.createScheduleModel(this.getViewSchedules());
    }

    private IMObjectListModel createScheduleModel(List<Entity> schedules) {
        return new IMObjectListModel(schedules, true, false);
    }

    public static interface ScheduleQueryListener
    extends QueryListener {
        public void now();
    }
}

