/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.workspace.workflow.scheduling.IntersectComparator;

public class Schedule {
    private final Entity schedule;
    private final Entity cageType;
    private final List<PropertySet> events = new ArrayList<PropertySet>();
    private final List<PropertySet> nonBlockingEvents = new ArrayList<PropertySet>();
    private final List<PropertySet> blockingEvents;
    private final List<Entity> areas;
    private final AppointmentRules rules;
    private final int startMins;
    private final int endMins;
    private final int slotSize;
    private boolean renderEven = true;

    public Schedule(Entity schedule, Entity cageType, List<Entity> areas, AppointmentRules rules) {
        this(schedule, cageType, -1, -1, 0, areas, rules);
    }

    public Schedule(Entity schedule, Entity cageType, int startMins, int endMins, int slotSize, List<Entity> areas, AppointmentRules rules) {
        this.schedule = schedule;
        this.cageType = cageType;
        this.startMins = startMins;
        this.endMins = endMins;
        this.slotSize = slotSize;
        this.areas = areas;
        this.rules = rules;
        this.blockingEvents = new ArrayList<PropertySet>();
    }

    public Schedule(Entity schedule, Entity cageType, int startMins, int endMins, int slotSize, List<Entity> areas, List<PropertySet> blockingEvents, AppointmentRules rules) {
        this.schedule = schedule;
        this.cageType = cageType;
        this.startMins = startMins;
        this.endMins = endMins;
        this.slotSize = slotSize;
        this.areas = areas;
        this.rules = rules;
        this.blockingEvents = blockingEvents;
    }

    public Schedule(Schedule source, AppointmentRules rules) {
        this(source, true, rules);
    }

    public Schedule(Schedule source, boolean copyBlockingEvents, AppointmentRules rules) {
        this(source.getSchedule(), source.getCageType(), source.getStartMins(), source.getEndMins(), source.getSlotSize(), source.areas, copyBlockingEvents ? source.blockingEvents : new ArrayList<PropertySet>(), rules);
    }

    public Entity getSchedule() {
        return this.schedule;
    }

    public Entity getCageType() {
        return this.cageType;
    }

    public String getName() {
        return this.schedule.getName();
    }

    public int getStartMins() {
        return this.startMins;
    }

    public int getEndMins() {
        return this.endMins;
    }

    public int getSlotSize() {
        return this.slotSize;
    }

    public List<Entity> getAreas() {
        return this.areas;
    }

    public void addEvent(PropertySet event) {
        if (Schedule.isBlockingEvent(event)) {
            this.blockingEvents.add(event);
        } else {
            this.nonBlockingEvents.add(event);
        }
        this.events.add(event);
    }

    public List<PropertySet> getEvents() {
        return this.events;
    }

    public PropertySet getEvent(Reference event) {
        int index = this.indexOf(event);
        return index != -1 ? this.events.get(index) : null;
    }

    public int indexOf(Reference event) {
        return this.indexOf(event, this.events);
    }

    public PropertySet getEventAfter(PropertySet event, Date startTime) {
        PropertySet result = null;
        int index = this.indexOf((Reference)event.getReference("act.objectReference"), this.events);
        if (index != -1) {
            while (index < this.events.size()) {
                PropertySet next = this.events.get(index);
                if (!Schedule.isBlockingEvent(next) && DateRules.compareTo((Date)startTime, (Date)next.getDate("act.startTime")) < 0) {
                    result = next;
                    break;
                }
                ++index;
            }
        }
        return result;
    }

    public boolean hasIntersectingEvent(PropertySet event, int slotSize) {
        return this.hasIntersectingEvent(event, true, slotSize);
    }

    public boolean hasIntersectingEvent(PropertySet event, boolean nonBlocking, int slotSize) {
        return Collections.binarySearch(nonBlocking ? this.nonBlockingEvents : this.events, event, new IntersectComparator(slotSize, this.rules)) >= 0;
    }

    public PropertySet getEvent(Date time, int slotSize) {
        return this.getEvent(time, slotSize, true);
    }

    public PropertySet getEvent(Date time, int slotSize, boolean includeBlockingEvents) {
        StartTimeComparator comparator = new StartTimeComparator(slotSize);
        return this.getEvent(time, time, comparator, includeBlockingEvents);
    }

    public PropertySet getIntersectingEvent(Date start, Date end, int slotSize) {
        return this.getIntersectingEvent(start, end, slotSize, true);
    }

    public PropertySet getIntersectingEvent(Date start, Date end, int slotSize, boolean includeBlockingEvents) {
        return this.getEvent(start, end, new IntersectComparator(slotSize, this.rules), includeBlockingEvents);
    }

    public void setRenderEven(boolean renderEven) {
        this.renderEven = renderEven;
    }

    public boolean getRenderEven() {
        return this.renderEven;
    }

    public static boolean isBlockingEvent(PropertySet event) {
        IMObjectReference reference = event.getReference("act.objectReference");
        return reference.isA("act.calendarBlock");
    }

    protected int indexOf(Reference event, List<PropertySet> list) {
        for (int i = 0; i < list.size(); ++i) {
            PropertySet set = list.get(i);
            if (!Objects.equals(event, set.getReference("act.objectReference"))) continue;
            return i;
        }
        return -1;
    }

    protected PropertySet getEvent(Date start, Date end, Comparator<PropertySet> comparator, boolean includeBlockingEvents) {
        PropertySet result = null;
        ObjectSet set = new ObjectSet();
        set.set("act.startTime", (Object)start);
        set.set("act.endTime", (Object)end);
        int index = Collections.binarySearch(this.nonBlockingEvents, set, comparator);
        if (index >= 0) {
            result = this.nonBlockingEvents.get(index);
        } else if (includeBlockingEvents && (index = Collections.binarySearch(this.blockingEvents, set, comparator)) >= 0) {
            result = this.blockingEvents.get(index);
        }
        return result;
    }

    private class StartTimeComparator
    implements Comparator<PropertySet> {
        private final int slotSize;

        StartTimeComparator(int slotSize) {
            this.slotSize = slotSize;
        }

        @Override
        public int compare(PropertySet o1, PropertySet o2) {
            Date startTime1 = o1.getDate("act.startTime");
            Date startTime2 = o2.getDate("act.startTime");
            int result = DateRules.getDate((Date)startTime1).compareTo(DateRules.getDate((Date)startTime2));
            if (result == 0) {
                int start1 = Schedule.this.rules.getSlotMinutes(startTime1, this.slotSize, false);
                int start2 = Schedule.this.rules.getSlotMinutes(startTime2, this.slotSize, false);
                result = start1 - start2;
            }
            return result;
        }
    }
}

