/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.roster;

import java.time.LocalDate;
import java.time.temporal.WeekFields;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.layout.ColumnLayoutData;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.query.AbstractEntityQuery;
import org.openvpms.web.component.im.query.DateNavigator;
import org.openvpms.web.component.im.query.DateSelector;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;

public abstract class RosterQuery<T extends Entity>
extends AbstractEntityQuery<T> {
    private final Context context;
    private Label title;
    private final DateSelector date;

    public RosterQuery(String[] archetypes, boolean checkIdentity, Class type, Context context) {
        super(archetypes, checkIdentity, type);
        this.context = context;
        this.date = new DateSelector();
        this.date.setNavigator((DateNavigator)new WeekNavigator());
        this.date.setListener(new ActionListener(){

            public void onAction(ActionEvent event) {
                RosterQuery.this.onDateChanged();
            }
        });
    }

    public void setDate(Date date) {
        this.date.setDate(date);
    }

    public Date getDate() {
        return this.date.getDate();
    }

    public boolean isAuto() {
        return true;
    }

    public Extent getHeight() {
        return this.getHeight(2);
    }

    public List<T> getResults() {
        return QueryHelper.query((Query)this);
    }

    protected void onDateChanged() {
        this.updateTitle();
        this.onQuery();
    }

    protected Context getContext() {
        return this.context;
    }

    protected Component createContainer() {
        return ColumnFactory.create((String)"WideCellSpacing");
    }

    protected void doLayout(Component container) {
        this.title = LabelFactory.create(null, (String)"bold");
        ColumnLayoutData layout = new ColumnLayoutData();
        layout.setAlignment(Alignment.ALIGN_CENTER);
        this.title.setLayoutData((LayoutData)layout);
        this.updateTitle();
        Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
        this.doQueryLayout((Component)row);
        container.add((Component)this.title);
        container.add((Component)row);
    }

    protected void addDate(Component container) {
        container.add(this.date.getComponent());
        this.getFocusGroup().add(this.date.getFocusGroup());
    }

    protected abstract void doQueryLayout(Component var1);

    private void updateTitle() {
        Date from = this.getDate();
        Date to = DateRules.getDate((Date)from, (int)6, (DateUnits)DateUnits.DAYS);
        boolean sameMonth = DateRules.getMonthStart((Date)from).equals(DateRules.getMonthStart((Date)to));
        String text = sameMonth ? Messages.format((String)"workflow.rostering.week.samemonth", (Object[])new Object[]{from, to}) : Messages.format((String)"workflow.rostering.week.diffmonth", (Object[])new Object[]{from, to});
        this.title.setText(text);
    }

    private static class WeekNavigator
    extends DateNavigator {
        private WeekNavigator() {
        }

        public Date getCurrent() {
            Date now = new Date();
            return this.getFirstDayOfWeek(now);
        }

        public Date getDate(Date date) {
            return this.getFirstDayOfWeek(date);
        }

        public Date getNext(Date date) {
            return DateRules.getDate((Date)this.getFirstDayOfWeek(date), (int)1, (DateUnits)DateUnits.WEEKS);
        }

        public Date getPrevious(Date date) {
            return DateRules.getDate((Date)this.getFirstDayOfWeek(date), (int)-1, (DateUnits)DateUnits.WEEKS);
        }

        public Date getNextTerm(Date date) {
            return DateRules.getDate((Date)this.getFirstDayOfWeek(date), (int)2, (DateUnits)DateUnits.WEEKS);
        }

        public Date getPreviousTerm(Date date) {
            return DateRules.getDate((Date)this.getFirstDayOfWeek(date), (int)-2, (DateUnits)DateUnits.WEEKS);
        }

        private Date getFirstDayOfWeek(Date date) {
            LocalDate localDate = DateRules.toLocalDate((Date)date);
            LocalDate firstDayOfWeek = localDate.with(WeekFields.of(Locale.getDefault()).dayOfWeek(), 1L);
            return DateRules.toDate((LocalDate)firstDayOfWeek);
        }
    }
}

