/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.roster;

import java.util.Date;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.DefaultIMObjectActions;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.workspace.AbstractCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.AbstractCalendarEventEditDialog;
import org.openvpms.web.workspace.workflow.roster.RosterBrowser;
import org.openvpms.web.workspace.workflow.roster.RosterEventEditor;

abstract class RosterCRUDWindow
extends AbstractCRUDWindow<Act> {
    private final RosterBrowser browser;

    public RosterCRUDWindow(RosterBrowser browser, Context context, HelpContext help) {
        super(Archetypes.create((String)"act.rosterEvent", Act.class), (IMObjectActions)DefaultIMObjectActions.getInstance(), context, help);
        this.browser = browser;
        context.setSchedule(null);
    }

    protected RosterBrowser getBrowser() {
        return this.browser;
    }

    protected void layoutButtons(ButtonSet buttons) {
        buttons.add(this.createEditButton());
        buttons.add(this.createDeleteButton());
        buttons.addKeyListener(8259, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                RosterCRUDWindow.this.onCopy();
            }
        });
        buttons.addKeyListener(8280, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                RosterCRUDWindow.this.onCut();
            }
        });
        buttons.addKeyListener(8278, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                RosterCRUDWindow.this.onPaste();
            }
        });
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        buttons.setEnabled("button.edit", enable);
        buttons.setEnabled("button.delete", enable);
    }

    protected void copy(Act act, Entity entity, Date date) {
        Act copy = (Act)IMObjectCreator.create((String)act.getArchetype());
        IMObjectBean source = this.getBean((IMObject)act);
        IMObjectBean target = this.getBean((IMObject)copy);
        copy.setActivityStartTime(act.getActivityStartTime());
        copy.setActivityEndTime(act.getActivityEndTime());
        target.setTarget("schedule", source.getTargetRef("schedule"));
        target.setTarget("user", source.getTargetRef("user"));
        this.paste(copy, entity, date);
    }

    protected abstract void setEntity(RosterEventEditor var1, Entity var2);

    private void onCopy() {
        this.browser.clearMarked();
        PropertySet selected = this.browser.getSelected();
        Act event = this.browser.getAct(selected);
        if (event != null) {
            this.browser.setMarked(selected, false);
        }
    }

    private void onCut() {
        this.browser.clearMarked();
        PropertySet selected = this.browser.getSelected();
        Act event = this.browser.getAct(selected);
        if (event != null) {
            this.browser.setMarked(selected, true);
        }
    }

    private void onPaste() {
        if (this.browser.getMarked() != null) {
            Act act = this.browser.getAct(this.browser.getMarked());
            Entity entity = this.browser.getSelectedEntity();
            Date date = this.browser.getSelectedDate();
            if (act == null) {
                InformationDialog.show((String)Messages.get((String)"workflow.scheduling.appointment.paste.title"), (String)Messages.get((String)"workflow.scheduling.appointment.paste.noexist"));
                this.onRefresh((IMObject)((Act)null));
                this.browser.clearMarked();
            } else if (entity == null || date == null) {
                InformationDialog.show((String)Messages.get((String)"workflow.scheduling.appointment.paste.title"), (String)Messages.get((String)"workflow.scheduling.appointment.paste.noslot"));
            } else if (this.browser.isCut()) {
                this.cut(act, entity, date);
            } else {
                this.copy(act, entity, date);
            }
        }
    }

    private void cut(Act act, Entity entity, Date date) {
        this.paste(act, entity, date);
        this.browser.clearMarked();
    }

    private void paste(Act act, Entity entity, Date date) {
        Date startTime = act.getActivityStartTime();
        Date endTime = act.getActivityEndTime();
        LayoutContext context = this.createLayoutContext(this.createEditTopic((IMObject)act));
        RosterEventEditor editor = (RosterEventEditor)this.createEditor((IMObject)act, context);
        AbstractCalendarEventEditDialog dialog = (AbstractCalendarEventEditDialog)this.edit((IMObjectEditor)editor, null);
        Date newStartTime = DateRules.addDateTime((Date)date, (Date)startTime);
        editor.setStartTime(newStartTime);
        if (endTime != null) {
            int duration = DateRules.minutesBetween((Date)startTime, (Date)endTime);
            Date newEndTime = DateRules.getDate((Date)newStartTime, (int)duration, (DateUnits)DateUnits.MINUTES);
            editor.setEndTime(newEndTime);
        }
        this.setEntity(editor, entity);
        dialog.setAlwaysCheckOverlap(true);
        dialog.save(true);
        this.browser.setSelected(null);
    }
}

