/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.roster;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.roster.AreaRosterQuery;
import org.openvpms.web.workspace.workflow.roster.AreaRosterTableModel;
import org.openvpms.web.workspace.workflow.roster.RosterBrowser;
import org.openvpms.web.workspace.workflow.roster.RosterEventGrid;
import org.openvpms.web.workspace.workflow.roster.RosterQuery;
import org.openvpms.web.workspace.workflow.roster.RosterTableModel;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;

public class AreaRosterBrowser
extends RosterBrowser {
    public AreaRosterBrowser(LayoutContext context) {
        super(new AreaRosterQuery(context.getContext()), context);
    }

    @Override
    protected RosterEventGrid query(RosterQuery query) {
        RosterService service = (RosterService)ServiceHelper.getBean(RosterService.class);
        Date from = query.getDate();
        Date to = this.getTo(from);
        List areas = ((AreaRosterQuery)query).getResults();
        LinkedHashMap<Entity, ScheduleEvents> events = new LinkedHashMap<Entity, ScheduleEvents>();
        for (Entity area : areas) {
            ScheduleEvents list = service.getScheduleEvents(area, from, to);
            events.put(area, list);
        }
        return new RosterEventGrid(from, to, 7, events);
    }

    @Override
    protected long getModHash(Entity entity, ScheduleEvents events, Date startDate, Date endDate, RosterService service) {
        return service.getModHash(entity, startDate, endDate);
    }

    @Override
    protected RosterTableModel createTableModel(RosterEventGrid grid, ScheduleColours colours) {
        return new AreaRosterTableModel(grid, this.getContext(), colours);
    }

    private Date getTo(Date from) {
        return DateRules.getDate((Date)from, (int)7, (DateUnits)DateUnits.DAYS);
    }
}

