/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.payment;

import org.openvpms.component.model.act.Act;
import org.openvpms.web.component.im.till.CashDrawer;
import org.openvpms.web.component.im.till.CashDrawerFactory;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workflow.SynchronousTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class OpenDrawerTask
extends SynchronousTask {
    public void execute(TaskContext context) {
        Act act = (Act)context.getObject("act.customerAccountPayment");
        if (act == null) {
            act = (Act)context.getObject("act.customerAccountRefund");
        }
        if (act != null) {
            this.open(act);
        }
    }

    public void open(Act act) {
        CashDrawer drawer;
        if ("POSTED".equals(act.getStatus()) && (drawer = ((CashDrawerFactory)ServiceHelper.getBean(CashDrawerFactory.class)).create(act)) != null) {
            try {
                if (drawer.canOpen() && drawer.needsOpen(act)) {
                    this.open(drawer);
                }
            }
            catch (Exception exception) {
                ErrorHelper.show((Throwable)exception);
            }
        }
    }

    private void open(CashDrawer drawer) {
        InformationDialog dialog = new InformationDialog(Messages.get((String)"till.opendrawer"));
        dialog.setStyleName("InformationDialog.Compact");
        dialog.show(1);
        try {
            drawer.open();
        }
        catch (Exception exception) {
            dialog.close();
            ErrorHelper.show((Throwable)exception);
        }
    }
}

