/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.sms;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.table.TableCellRenderer;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.IMObjectTableBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.sms.SMSReplyUpdater;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.echo.table.EvenOddTableCellRenderer;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.messaging.sms.SMSReplyQuery;
import org.openvpms.web.workspace.workflow.messaging.sms.TopLevelSMSReplyTableModel;

public class SMSReplyBrowser
extends IMObjectTableBrowser<Act> {
    private final boolean canUpdateStatus;
    private final SMSReplyUpdater replyUpdater;

    public SMSReplyBrowser(SMSReplyQuery query, DefaultLayoutContext layoutContext) {
        super((Query)query, null, (IMTableModel)new TopLevelSMSReplyTableModel((LayoutContext)layoutContext), (LayoutContext)layoutContext);
        UserRules rules = (UserRules)ServiceHelper.getBean(UserRules.class);
        this.canUpdateStatus = rules.canSave(layoutContext.getContext().getUser(), "act.smsReply");
        this.replyUpdater = (SMSReplyUpdater)ServiceHelper.getBean(SMSReplyUpdater.class);
    }

    protected void notifySelected(Act selected) {
        this.markRead(selected);
        super.notifySelected((Object)selected);
    }

    protected PagedIMTable<Act> createTable(final IMTableModel<Act> model) {
        PagedIMTable table = super.createTable(model);
        if (this.canUpdateStatus) {
            table.getTable().setDefaultRenderer(Object.class, (TableCellRenderer)new EvenOddTableCellRenderer(){

                public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
                    Component result = super.getTableCellRendererComponent(table, value, column, row);
                    if ("PENDING".equals(((Act)model.getObjects().get(row)).getStatus()) && result instanceof Label) {
                        result.setStyleName("bold");
                    }
                    return result;
                }
            });
        }
        return table;
    }

    private void markRead(Act message) {
        if (this.canUpdateStatus && "PENDING".equals(message.getStatus())) {
            this.replyUpdater.markRead(message);
            Act select = (Act)this.getSelected();
            this.getTable().getTable().getModel().refresh();
            this.setSelected(select);
        }
    }
}

