/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.sms;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.sms.message.OutboundMessage;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.workspace.AbstractViewCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.help.HelpContext;

public class SMSCRUDWindow
extends AbstractViewCRUDWindow<Act> {
    private static final String MARK_REVIEWED = "button.markReviewed";
    private static final String UNMARK_REVIEWED = "button.unmarkReviewed";

    public SMSCRUDWindow(Archetypes<Act> archetypes, Context context, HelpContext help) {
        super(archetypes, (IMObjectActions)SMSActions.INSTANCE, context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(MARK_REVIEWED, this.action("act.smsMessage", this::markReviewed, "workflow.sms.reviewed.title"));
        buttons.add(UNMARK_REVIEWED, this.action("act.smsMessage", this::unmarkReviewed, "workflow.sms.unreviewed.title"));
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(MARK_REVIEWED, enable && SMSActions.INSTANCE.canReview((Act)this.getObject()));
        buttons.setEnabled(UNMARK_REVIEWED, enable && SMSActions.INSTANCE.canUnreview((Act)this.getObject()));
    }

    private void markReviewed(Act object) {
        if (SMSActions.INSTANCE.canReview(object)) {
            object.setStatus(OutboundMessage.Status.REVIEWED.toString());
            SaveHelper.save((IMObject)object);
        }
        this.onRefresh((IMObject)object);
    }

    private void unmarkReviewed(Act object) {
        if (SMSActions.INSTANCE.canUnreview(object)) {
            object.setStatus(OutboundMessage.Status.ERROR.toString());
            SaveHelper.save((IMObject)object);
        }
        this.onRefresh((IMObject)object);
    }

    private static class SMSActions
    extends ActActions<Act> {
        public static final SMSActions INSTANCE = new SMSActions();

        private SMSActions() {
        }

        public boolean canCreate() {
            return false;
        }

        public boolean canDelete(Act object) {
            return OutboundMessage.Status.PENDING.toString().equals(object.getStatus());
        }

        boolean canReview(Act object) {
            return OutboundMessage.Status.ERROR.toString().equals(object.getStatus());
        }

        boolean canUnreview(Act object) {
            return OutboundMessage.Status.REVIEWED.toString().equals(object.getStatus());
        }
    }
}

