/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.messages;

import java.util.Set;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.im.customer.CustomerParticipationEditor;
import org.openvpms.web.component.im.edit.act.ActEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientParticipationEditor;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.messaging.messages.ToAddressEditor;
import org.openvpms.web.workspace.workflow.messaging.messages.UserMessageLayoutStrategy;

public class UserMessageEditor
extends ActEditor {
    private final ToAddressEditor toAddressEditor;
    private final PatientRules rules = (PatientRules)ServiceHelper.getBean(PatientRules.class);

    public UserMessageEditor(Act act, IMObject parent, LayoutContext context) {
        super(act, parent, context);
        if (act.isNew()) {
            this.setFrom(context.getContext().getUser());
            this.initParticipant("customer", (IMObject)context.getContext().getCustomer());
            this.initParticipant("patient", (IMObject)context.getContext().getPatient());
        }
        HelpContext help = context.getHelpContext().subtopic("to");
        this.toAddressEditor = new ToAddressEditor(act, this.getProperty("to"), (LayoutContext)new DefaultLayoutContext(context, help));
        this.addEditor((Editor)this.toAddressEditor);
    }

    public User getFrom() {
        return (User)this.getObject(this.getObject().getCreatedBy());
    }

    public void setFrom(User from) {
        Reference reference = from != null ? from.getObjectReference() : null;
        this.getObject().setCreatedBy(reference);
    }

    public User getTo() {
        return (User)this.getParticipant("to");
    }

    public void setTo(User to) {
        this.toAddressEditor.setTo(to);
    }

    public Set<User> getToUsers() {
        return this.toAddressEditor.getTo();
    }

    public String getSubject() {
        return this.getStringProperty("description");
    }

    public void setSubject(String subject) {
        Property description = this.getProperty("description");
        description.setValue((Object)subject);
    }

    public String getMessage() {
        return this.getStringProperty("message");
    }

    public void setMessage(String message) {
        Property property = this.getProperty("message");
        property.setValue((Object)message);
    }

    protected void doSave() {
        throw new IllegalStateException();
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        UserMessageLayoutStrategy strategy = new UserMessageLayoutStrategy();
        strategy.addComponent(this.toAddressEditor.getComponentState());
        return strategy;
    }

    protected void onLayoutCompleted() {
        CustomerParticipationEditor customer = this.getCustomerEditor();
        PatientParticipationEditor patient = this.getPatientEditor();
        customer.setPatientParticipationEditor(patient);
        customer.addModifiableListener(modifiable -> this.onCustomerChanged());
    }

    private CustomerParticipationEditor getCustomerEditor() {
        ParticipationEditor result = this.getParticipationEditor("customer", true);
        return (CustomerParticipationEditor)result;
    }

    private PatientParticipationEditor getPatientEditor() {
        ParticipationEditor result = this.getParticipationEditor("patient", true);
        return (PatientParticipationEditor)result;
    }

    private void onCustomerChanged() {
        try {
            Party customer = (Party)this.getCustomerEditor().getEntity();
            Party patient = (Party)this.getPatientEditor().getEntity();
            if (customer != null && patient != null && !this.rules.isOwner(customer, patient)) {
                this.getPatientEditor().setEntity(null);
            }
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show((Throwable)exception);
        }
    }

    private String getStringProperty(String name) {
        Property description = this.getProperty(name);
        Object value = description.getValue();
        return value != null ? value.toString() : null;
    }
}

