/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.messages;

import java.util.ArrayList;
import java.util.Set;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.edit.AlertListener;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.edit.act.ParticipationHelper;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.select.AbstractSelectorListener;
import org.openvpms.web.component.im.select.MultiIMObjectSelector;
import org.openvpms.web.component.im.select.SelectorListener;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.AbstractModifiable;
import org.openvpms.web.component.property.ErrorListener;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

class ToAddressEditor
extends AbstractModifiable
implements PropertyEditor {
    private final MultiIMObjectSelector<Entity> selector;
    private final ComponentState state;
    private final UserRules rules;
    private final ArchetypeService service;
    private final Participation participation;
    private static final String[] SHORT_NAMES = new String[]{"security.user", "entity.userGroup"};

    public ToAddressEditor(Act act, Property property, LayoutContext context) {
        User user;
        this.participation = ParticipationHelper.getParticipation((Property)property, (boolean)true);
        if (this.participation != null) {
            this.participation.setAct(act.getObjectReference());
        }
        this.selector = new MultiIMObjectSelector(property.getDisplayName(), context, SHORT_NAMES);
        this.selector.setListener((SelectorListener)new AbstractSelectorListener<Entity>(){

            public void selected(Entity object) {
                ToAddressEditor.this.onSelected(object);
            }
        });
        this.selector.getTextField().setWidth(new Extent(100, 2));
        this.state = new ComponentState(this.selector.getComponent(), property, this.selector.getFocusGroup());
        this.rules = (UserRules)ServiceHelper.getBean(UserRules.class);
        this.service = ServiceHelper.getArchetypeService();
        if (this.participation != null && this.participation.getEntity() != null && (user = (User)this.service.get(this.participation.getEntity(), User.class)) != null) {
            this.selector.setObject((IMObject)user);
        }
    }

    public Property getProperty() {
        return this.state.getProperty();
    }

    public Set<User> getTo() {
        return this.rules.getUsers(new ArrayList(this.selector.getObjects()));
    }

    public void setTo(User to) {
        ArrayList<User> users = new ArrayList<User>();
        if (to != null) {
            users.add(to);
        }
        this.selector.setObjects(users);
        this.onSelected((Entity)to);
    }

    public Component getComponent() {
        return this.selector.getComponent();
    }

    public ComponentState getComponentState() {
        return this.state;
    }

    public FocusGroup getFocusGroup() {
        return this.selector.getFocusGroup();
    }

    public void dispose() {
    }

    public boolean isModified() {
        return true;
    }

    public void clearModified() {
    }

    public void addModifiableListener(ModifiableListener listener) {
    }

    public void addModifiableListener(ModifiableListener listener, int index) {
    }

    public void removeModifiableListener(ModifiableListener listener) {
    }

    public void setErrorListener(ErrorListener listener) {
    }

    public ErrorListener getErrorListener() {
        return null;
    }

    public void setAlertListener(AlertListener listener) {
    }

    public AlertListener getAlertListener() {
        return null;
    }

    protected boolean doValidation(Validator validator) {
        boolean valid = false;
        if (this.selector.isValid() && !this.getTo().isEmpty()) {
            valid = true;
        } else {
            Property property = this.state.getProperty();
            String notFound = this.selector.getFirstNotFound();
            String message = notFound != null ? Messages.format((String)"workflow.message.invaliduserorgroup", (Object[])new Object[]{notFound}) : Messages.format((String)"property.error.required", (Object[])new Object[]{property.getDisplayName()});
            validator.add((Modifiable)property, new ValidatorError(property, message));
        }
        return valid;
    }

    private void onSelected(Entity entity) {
        if (this.participation != null) {
            Reference ref = null;
            if (TypeHelper.isA((IMObject)entity, (String)"security.user")) {
                ref = entity.getObjectReference();
                this.participation.setEntity(entity.getObjectReference());
            } else if (TypeHelper.isA((IMObject)entity, (String)"entity.userGroup")) {
                IMObjectBean bean = this.service.getBean((IMObject)entity);
                ref = bean.getTargetRef("users");
            }
            this.participation.setEntity(ref);
        }
    }
}

