/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.messages;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.table.act.AbstractActTableModel;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.resource.i18n.format.DateFormatter;

public class MessageTableModel
extends AbstractActTableModel<Act> {
    private final Map<String, String> statuses = LookupNameHelper.getLookupNames((String)"act.userMessage", (String)"status");
    private static final String[] NODES = new String[]{"startTime", "description", "from", "reason", "status", "item"};

    public MessageTableModel(String[] shortNames, LayoutContext context) {
        super(shortNames, context);
    }

    protected String[] getNodeNames() {
        return NODES;
    }

    protected boolean showArchetypeColumn(List<ArchetypeDescriptor> archetypes) {
        return false;
    }

    protected Object getValue(Act object, DescriptorTableColumn column, int row) {
        Object result;
        String columnName = column.getName();
        if ("startTime".equals(columnName)) {
            result = this.formatStartTime(object);
        } else if ("from".equals(columnName)) {
            result = this.getFrom(object);
        } else if ("status".equals(columnName)) {
            result = this.getStatus(object);
        } else if ("item".equals(columnName)) {
            List values = column.getValues((IMObject)object);
            if (values != null && !values.isEmpty()) {
                result = values.get(0);
                if (result instanceof ActRelationship) {
                    Reference ref = ((ActRelationship)result).getTarget();
                    String name = this.getDisplayName(ref.getArchetype());
                    LayoutContext layout = this.getLayoutContext();
                    Context context = layout.getContext();
                    ContextSwitchListener listener = layout.getContextSwitchListener();
                    result = new IMObjectReferenceViewer(ref, name, listener, context).getComponent();
                }
            } else {
                result = null;
            }
        } else {
            result = super.getValue((IMObject)object, column, row);
        }
        return result;
    }

    private String formatStartTime(Act act) {
        Date startTime = act.getActivityStartTime();
        return startTime != null ? DateFormatter.formatDateTimeAbbrev((Date)startTime) : null;
    }

    private String getFrom(Act object) {
        return this.getLayoutContext().getNames().getName(object.getCreatedBy());
    }

    private String getStatus(Act object) {
        String status = object.getStatus();
        if ("READ".equals(status)) {
            status = "PENDING";
        }
        return this.statuses.get(status);
    }
}

