/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.messages;

import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.table.TableCellRenderer;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.IMObjectTableBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.table.EvenOddTableCellRenderer;
import org.openvpms.web.workspace.workflow.messaging.messages.MessageQuery;

public class MessageBrowser
extends IMObjectTableBrowser<Act> {
    public MessageBrowser(MessageQuery query, LayoutContext context) {
        super((Query)query, context);
    }

    protected void notifySelected(Act selected) {
        this.markRead(selected);
        super.notifySelected((Object)selected);
    }

    protected PagedIMTable<Act> createTable(final IMTableModel<Act> model) {
        PagedIMTable table = super.createTable(model);
        table.getTable().setDefaultRenderer(Object.class, (TableCellRenderer)new EvenOddTableCellRenderer(){

            public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
                Component result = super.getTableCellRendererComponent(table, value, column, row);
                if ("PENDING".equals(((Act)model.getObjects().get(row)).getStatus()) && result instanceof Label) {
                    result.setStyleName("bold");
                }
                return result;
            }
        });
        return table;
    }

    private void markRead(Act message) {
        User user = this.getContext().getContext().getUser();
        if (user != null && "PENDING".equals(message.getStatus())) {
            IMObjectBean bean = IMObjectHelper.getBean((IMObject)message);
            if (Objects.equals(user.getObjectReference(), bean.getTargetRef("to"))) {
                message.setStatus("READ");
                bean.save();
                Act select = (Act)this.getSelected();
                this.getTable().getTable().getModel().refresh();
                this.setSelected(select);
            }
        }
    }
}

