/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging;

import echopointng.TabbedPane;
import java.util.Collection;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.message.MessageArchetypes;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.app.DefaultContextSwitchListener;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.DefaultIMObjectTableBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.workspace.AbstractViewCRUDWindow;
import org.openvpms.web.component.workspace.BrowserCRUDWindowTab;
import org.openvpms.web.component.workspace.TabComponent;
import org.openvpms.web.component.workspace.TabbedWorkspace;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.tabpane.ObjectTabPaneModel;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.CustomerPatientSummary;
import org.openvpms.web.workspace.patient.summary.CustomerPatientSummaryFactory;
import org.openvpms.web.workspace.workflow.messaging.messages.MessageBrowser;
import org.openvpms.web.workspace.workflow.messaging.messages.MessageQuery;
import org.openvpms.web.workspace.workflow.messaging.messages.MessagingCRUDWindow;
import org.openvpms.web.workspace.workflow.messaging.sms.ReplyCRUDWindow;
import org.openvpms.web.workspace.workflow.messaging.sms.SMSCRUDWindow;
import org.openvpms.web.workspace.workflow.messaging.sms.SMSQuery;
import org.openvpms.web.workspace.workflow.messaging.sms.SMSReplyBrowser;
import org.openvpms.web.workspace.workflow.messaging.sms.SMSReplyQuery;
import org.openvpms.web.workspace.workflow.messaging.sms.SMSTableModel;

public class MessagingWorkspace
extends TabbedWorkspace<Act> {
    private final Preferences preferences;
    private int messageIndex = -1;

    public MessagingWorkspace(Context context, Preferences preferences) {
        super("workflow.messaging", context);
        this.preferences = preferences;
    }

    public boolean canUpdate(String shortName) {
        return TypeHelper.isA((String)shortName, (Collection)MessageArchetypes.MESSAGES);
    }

    public void update(String archetype) {
        if (TypeHelper.isA((String)archetype, (Collection)MessageArchetypes.MESSAGES)) {
            TabbedPane pane = this.getTabbedPane();
            if (this.messageIndex != -1 && pane.getSelectedIndex() != this.messageIndex) {
                pane.setSelectedIndex(this.messageIndex);
            }
        }
    }

    public Component getSummary() {
        Tab tab = (Tab)this.getSelected();
        Act object = (Act)tab.getWindow().getObject();
        if (object != null) {
            CustomerPatientSummaryFactory factory = (CustomerPatientSummaryFactory)ServiceHelper.getBean(CustomerPatientSummaryFactory.class);
            CustomerPatientSummary summary = factory.createCustomerPatientSummary(this.getContext(), this.getHelpContext(), this.preferences);
            return summary.getSummary(object);
        }
        return null;
    }

    protected Class<Act> getType() {
        return Act.class;
    }

    protected void addTabs(ObjectTabPaneModel<TabComponent> model) {
        this.addMessagesBrowser(model);
        this.addSMSBrowser(model);
        this.addSMSRepliesBrowser(model);
    }

    private void addMessagesBrowser(ObjectTabPaneModel<TabComponent> model) {
        Archetypes archetypes = Archetypes.create((Collection)MessageArchetypes.MESSAGES, Act.class);
        Context context = this.getContext();
        HelpContext help = this.subtopic("message");
        MessageQuery query = new MessageQuery((Entity)context.getUser(), (LayoutContext)new DefaultLayoutContext(context, help));
        MessageBrowser browser = new MessageBrowser(query, (LayoutContext)new DefaultLayoutContext(context, help));
        MessagingCRUDWindow window = new MessagingCRUDWindow((Archetypes<Act>)archetypes, context, help);
        this.messageIndex = this.addTab("workflow.messaging.messages", model, (TabComponent)new Tab((Browser<Act>)browser, window));
    }

    private void addSMSBrowser(ObjectTabPaneModel<TabComponent> model) {
        Context context = this.getContext();
        HelpContext help = this.subtopic("sms");
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(context, help);
        SMSQuery query = new SMSQuery((LayoutContext)layoutContext);
        layoutContext.setContextSwitchListener((ContextSwitchListener)DefaultContextSwitchListener.INSTANCE);
        DefaultIMObjectTableBrowser browser = new DefaultIMObjectTableBrowser((Query)query, null, (IMTableModel)new SMSTableModel((LayoutContext)layoutContext), (LayoutContext)layoutContext);
        Archetypes archetypes = Archetypes.create((String)"act.smsMessage", Act.class);
        SMSCRUDWindow window = new SMSCRUDWindow((Archetypes<Act>)archetypes, context, help);
        this.addTab("workflow.messaging.sms", model, (TabComponent)new Tab((Browser<Act>)browser, window));
    }

    private void addSMSRepliesBrowser(ObjectTabPaneModel<TabComponent> model) {
        Context context = this.getContext();
        HelpContext help = this.subtopic("smsreply");
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(context, help);
        SMSReplyQuery query = new SMSReplyQuery((LayoutContext)layoutContext);
        layoutContext.setContextSwitchListener((ContextSwitchListener)DefaultContextSwitchListener.INSTANCE);
        SMSReplyBrowser browser = new SMSReplyBrowser(query, layoutContext);
        Archetypes archetypes = Archetypes.create((String)"act.smsReply", Act.class);
        ReplyCRUDWindow window = new ReplyCRUDWindow((Archetypes<Act>)archetypes, context, help);
        this.addTab("workflow.messaging.smsreply", model, (TabComponent)new Tab((Browser<Act>)browser, window));
    }

    private class Tab
    extends BrowserCRUDWindowTab<Act> {
        public Tab(Browser<Act> browser, AbstractViewCRUDWindow<Act> window) {
            super(browser, window);
        }

        public void show() {
            super.show();
            MessagingWorkspace.this.firePropertyChange("summary", null, null);
        }

        protected void select(Act object) {
            Act current = (Act)this.getWindow().getObject();
            super.select((IMObject)object);
            if (MessagingWorkspace.this.getSelected() == this && current != object) {
                MessagingWorkspace.this.firePropertyChange("summary", null, null);
            }
        }
    }
}

