/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.investigation;

import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.model.act.Act;
import org.openvpms.laboratory.internal.dispatcher.Confirmation;
import org.openvpms.laboratory.internal.dispatcher.OrderDispatcher;
import org.openvpms.laboratory.order.WebOrderConfirmation;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.investigation.OrderConfirmationDialog;

public class OrderConfirmationManager {
    private final OrderDispatcher dispatcher = (OrderDispatcher)ServiceHelper.getBean(OrderDispatcher.class);

    public void confirm(Act investigation, HelpContext help, final Runnable listener) {
        OrderConfirmationDialog dialog = this.createConfirmationDialog(investigation, help);
        if (dialog != null) {
            if (listener != null) {
                dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                    public void onClose(WindowPaneEvent event) {
                        OrderConfirmationManager.this.runProtected(listener);
                    }
                });
            }
            dialog.show();
        } else if (listener != null) {
            this.runProtected(listener);
        }
    }

    public OrderConfirmationDialog createConfirmationDialog(Act investigation, HelpContext help) {
        OrderConfirmationDialog result = null;
        Confirmation confirmation = this.dispatcher.order(investigation);
        if (confirmation != null && confirmation.getConfirmation() instanceof WebOrderConfirmation) {
            result = new OrderConfirmationDialog(confirmation.getOrder(), (WebOrderConfirmation)confirmation.getConfirmation(), investigation, confirmation.getService(), help);
        }
        return result;
    }

    private void runProtected(Runnable listener) {
        try {
            listener.run();
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
    }
}

