/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.investigation;

import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.OrderServices;
import org.openvpms.web.workspace.patient.history.PatientHistoryActions;
import org.openvpms.web.workspace.patient.investigation.ResultChecker;
import org.openvpms.web.workspace.workflow.investigation.InvestigationCanceller;
import org.openvpms.web.workspace.workflow.investigation.OrderConfirmationManager;

class InvestigationCRUDWindow
extends ResultSetCRUDWindow<Act> {
    private static final String CHECK_RESULTS = "button.checkResults";
    private static final String MARK_REVIEWED = "button.markReviewed";
    private static final String UNMARK_REVIEWED = "button.unmarkReviewed";
    private static final String CONFIRM_ORDER = "button.confirmOrder";
    private static final String CANCEL_INVESTIGATION = "button.cancelInvestigation";

    public InvestigationCRUDWindow(Archetypes<Act> archetypes, Query<Act> query, ResultSet<Act> set, Context context, HelpContext help) {
        super(archetypes, (IMObjectActions)InvestigationActions.INSTANCE, query, set, context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        buttons.add(this.createViewButton());
        buttons.add(this.createEditButton());
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
        buttons.add(CONFIRM_ORDER, this.action("act.patientInvestigation", this::confirmOrder, "investigation.order.confirm.title"));
        buttons.add(CHECK_RESULTS, this.action("act.patientInvestigation", this::checkResults, "investigation.check.title"));
        buttons.add(MARK_REVIEWED, this.action("act.patientInvestigation", this::markReviewed, "investigation.reviewed.title"));
        buttons.add(UNMARK_REVIEWED, this.action("act.patientInvestigation", this::unmarkReviewed, "investigation.unreviewed.title"));
        buttons.add(CANCEL_INVESTIGATION, this.action("act.patientInvestigation", this::cancelInvestigation, "investigation.cancel.title"));
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        Act object = (Act)this.getObject();
        buttons.setEnabled("button.print", enable);
        buttons.setEnabled("button.mail", enable);
        buttons.setEnabled(CONFIRM_ORDER, enable && InvestigationActions.INSTANCE.canConfirmOrder(object));
        buttons.setEnabled(CHECK_RESULTS, enable && InvestigationActions.INSTANCE.canCheck(object));
        buttons.setEnabled(MARK_REVIEWED, enable && InvestigationActions.INSTANCE.canReview(object));
        buttons.setEnabled(UNMARK_REVIEWED, enable && InvestigationActions.INSTANCE.canUnreview(object));
        buttons.setEnabled(CANCEL_INVESTIGATION, enable && InvestigationActions.INSTANCE.canCancel(object));
    }

    private void confirmOrder(Act investigation) {
        OrderConfirmationManager manager = new OrderConfirmationManager();
        manager.confirm(investigation, this.getHelpContext(), () -> this.onRefresh((IMObject)investigation));
    }

    private void checkResults(Act investigation) {
        CheckResultsCommand command = new CheckResultsCommand(investigation);
        command.run();
        this.onRefresh((IMObject)investigation);
    }

    private void markReviewed(Act investigation) {
        if (InvestigationActions.INSTANCE.canReview(investigation)) {
            investigation.setStatus2("REVIEWED");
            SaveHelper.save((IMObject)investigation);
        }
        this.onRefresh((IMObject)investigation);
    }

    private void unmarkReviewed(Act investigation) {
        if (InvestigationActions.INSTANCE.canUnreview(investigation)) {
            investigation.setStatus2("RECEIVED");
            SaveHelper.save((IMObject)investigation);
        }
        this.onRefresh((IMObject)investigation);
    }

    private void cancelInvestigation(final Act investigation) {
        if (InvestigationActions.INSTANCE.canCancel(investigation)) {
            Context context = this.getContext();
            User user = context.getUser();
            Party practice = context.getPractice();
            OrderServices orderServices = (OrderServices)ServiceHelper.getBean(OrderServices.class);
            IArchetypeRuleService service = ServiceHelper.getArchetypeService();
            PatientRules patientRules = (PatientRules)ServiceHelper.getBean(PatientRules.class);
            final InvestigationCanceller canceller = new InvestigationCanceller(investigation, user, practice, orderServices, patientRules, (IArchetypeService)service);
            String message = canceller.isCharged() ? Messages.get((String)"investigation.cancel.charged") : Messages.get((String)"investigation.cancel.message");
            ConfirmationDialog.show((String)Messages.get((String)"investigation.cancel.title"), (String)message, (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    canceller.cancel();
                    InvestigationCRUDWindow.this.onRefresh((IMObject)investigation);
                }
            });
        } else {
            this.onRefresh((IMObject)investigation);
        }
    }

    private static class CheckResultsCommand {
        private final ResultChecker checker;

        public CheckResultsCommand(Act investigation) {
            this.checker = new ResultChecker((DocumentAct)investigation);
        }

        public boolean canRun() {
            return this.checker.canCheckResults();
        }

        public void run() {
            if (this.canRun()) {
                this.checker.checkResults();
            }
        }
    }

    private static class InvestigationActions
    extends PatientHistoryActions {
        public static final InvestigationActions INSTANCE = new InvestigationActions();

        private InvestigationActions() {
        }

        public boolean canCreate() {
            return false;
        }

        @Override
        public boolean canDelete(Act object) {
            return false;
        }

        public boolean canConfirmOrder(Act object) {
            return "IN_PROGRESS".equals(object.getStatus()) && ("CONFIRM".equals(object.getStatus2()) || "CONFIRM_DEFERRED".equals(object.getStatus2()));
        }

        boolean canCheck(Act object) {
            return new CheckResultsCommand(object).canRun();
        }

        boolean canCancel(Act object) {
            return !"CANCELLED".equals(object.getStatus()) && !"RECEIVED".equals(object.getStatus2()) && !"REVIEWED".equals(object.getStatus2());
        }
    }
}

