/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.consult;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.functor.ActComparator;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.GetInvoiceTask;

public class GetConsultInvoiceTask
extends GetInvoiceTask {
    private final IArchetypeService service = ServiceHelper.getArchetypeService();

    @Override
    public void execute(TaskContext context) {
        FinancialAct invoice;
        FinancialAct eventInvoice = this.getInvoiceForEvent(context);
        FinancialAct result = eventInvoice == null ? this.getInvoice(context) : ("POSTED".equals(eventInvoice.getStatus()) ? ((invoice = this.getInvoice(context)) != null ? invoice : eventInvoice) : eventInvoice);
        if (result != null) {
            context.addObject((IMObject)result);
        }
    }

    protected FinancialAct getInvoiceForEvent(TaskContext context) {
        Act event = (Act)context.getObject("act.patientClinicalEvent");
        FinancialAct invoice = null;
        if (event != null) {
            invoice = this.getInvoiceForEvent(event, context);
        }
        return invoice;
    }

    protected FinancialAct getInvoiceForEvent(Act event, TaskContext context, Set<Reference> seen, List<FinancialAct> posted) {
        FinancialAct invoice = null;
        Party customer = context.getCustomer();
        if (customer == null) {
            throw new IllegalStateException("Context has no customer");
        }
        Reference customerRef = customer.getObjectReference();
        IMObjectBean bean = this.service.getBean((IMObject)event);
        for (ActRelationship relationship : bean.getValues("chargeItems", ActRelationship.class)) {
            FinancialAct act;
            IMObjectBean itemBean;
            Reference invoiceRef;
            FinancialAct item = (FinancialAct)this.service.get(relationship.getTarget(), FinancialAct.class);
            if (item == null || (invoiceRef = (itemBean = this.service.getBean((IMObject)item)).getSourceRef("invoice")) == null || seen.contains(invoiceRef) || (act = (FinancialAct)this.service.get(invoiceRef)) == null) continue;
            seen.add(invoiceRef);
            IMObjectBean invoiceBean = this.service.getBean((IMObject)act);
            if (!Objects.equals(customerRef, invoiceBean.getTargetRef("customer"))) continue;
            if (!"POSTED".equals(act.getStatus())) {
                invoice = act;
                break;
            }
            posted.add(act);
        }
        return invoice;
    }

    protected FinancialAct selectMostRecent(List<FinancialAct> invoices) {
        FinancialAct result = null;
        if (!invoices.isEmpty()) {
            if (invoices.size() > 1) {
                invoices.sort(ActComparator.descending());
            }
            result = invoices.get(0);
        }
        return result;
    }

    private FinancialAct getInvoiceForEvent(Act event, TaskContext context) {
        HashSet<Reference> seen = new HashSet<Reference>();
        ArrayList<FinancialAct> posted = new ArrayList<FinancialAct>();
        FinancialAct invoice = this.getInvoiceForEvent(event, context, seen, posted);
        return invoice != null ? invoice : this.selectMostRecent(posted);
    }
}

