/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.consult;

import java.util.Date;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.workflow.AbstractConfirmationTask;
import org.openvpms.web.component.workflow.ConditionalCreateTask;
import org.openvpms.web.component.workflow.ConditionalTask;
import org.openvpms.web.component.workflow.DefaultTaskContext;
import org.openvpms.web.component.workflow.EvalTask;
import org.openvpms.web.component.workflow.LocalTask;
import org.openvpms.web.component.workflow.NodeConditionTask;
import org.openvpms.web.component.workflow.ReloadTask;
import org.openvpms.web.component.workflow.SynchronousTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskProperties;
import org.openvpms.web.component.workflow.UpdateActStatusTask;
import org.openvpms.web.component.workflow.UpdateActTask;
import org.openvpms.web.component.workflow.WorkflowImpl;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.EditVisitTask;
import org.openvpms.web.workspace.workflow.GetClinicalEventTask;
import org.openvpms.web.workspace.workflow.MandatoryCustomerAlertTask;
import org.openvpms.web.workspace.workflow.MandatoryPatientAlertTask;
import org.openvpms.web.workspace.workflow.consult.ClinicianSelectionDialog;
import org.openvpms.web.workspace.workflow.consult.GetConsultInvoiceTask;
import org.openvpms.web.workspace.workflow.consult.UpdateClinicianTask;

public class ConsultWorkflow
extends WorkflowImpl {
    private final TaskContext initial;

    public ConsultWorkflow(Act act, Context external, HelpContext help) {
        super(help);
        this.initial = this.createContext(act, external, help);
        this.addTasks(act, external);
    }

    public void start() {
        super.start(this.initial);
    }

    protected TaskContext createContext(Act act, Context external, HelpContext help) {
        User clinician;
        Party practice = external.getPractice();
        if (practice == null) {
            throw new IllegalStateException("Context has no practice");
        }
        IMObjectBean bean = this.getBean((IMObject)act);
        Party customer = (Party)bean.getTarget("customer", Party.class);
        Party patient = (Party)bean.getTarget("patient", Party.class);
        if (UserHelper.useLoggedInClinician((Context)external)) {
            clinician = external.getUser();
        } else {
            clinician = (User)bean.getTarget("clinician", User.class);
            if (clinician == null) {
                clinician = external.getClinician();
            }
        }
        DefaultTaskContext context = new DefaultTaskContext(help);
        context.setCustomer(customer);
        context.setPatient(patient);
        context.setClinician(clinician);
        context.setUser(external.getUser());
        context.setPractice(practice);
        context.setLocation(external.getLocation());
        context.setDepartment(external.getDepartment());
        context.addObject((IMObject)act);
        return context;
    }

    protected void addTasks(Act act, final Context external) {
        if (!UserHelper.useLoggedInClinician((Context)this.initial)) {
            this.addTask((Task)new ClinicianSelectionTask(this.getHelpContext()));
        }
        this.addTask(this.createInProgressTask(act));
        this.addTask((Task)new UpdateClinicianTask(act.getArchetype()));
        this.addTask((Task)new MandatoryCustomerAlertTask());
        this.addTask((Task)new MandatoryPatientAlertTask());
        Act appointment = TypeHelper.isA((IMObject)act, (String)"act.customerAppointment") ? act : null;
        this.addTask((Task)new GetClinicalEventTask(act.getActivityStartTime(), appointment));
        this.addTask((Task)new UpdateClinicianTask("act.patientClinicalEvent"));
        this.addTask((Task)new GetConsultInvoiceTask());
        this.addTask((Task)new ConditionalCreateTask("act.customerAccountChargesInvoice"));
        this.addTask((Task)new UpdateInvoiceClinicianTask());
        this.addTask((Task)new LocalTask((Task)this.createEditVisitTask(), new String[]{"party.patient*", "party.customer*", "security.user", "entity.department"}));
        this.addTask((Task)new ReloadTask("act.patientClinicalEvent"));
        this.addTask(this.createBilledTask(act));
        this.addTask((Task)new SynchronousTask(){

            public void execute(TaskContext context) {
                external.setCustomer(context.getCustomer());
                external.setPatient(context.getPatient());
                external.setClinician(context.getClinician());
                external.setDepartment(context.getDepartment());
            }
        });
    }

    protected EditVisitTask createEditVisitTask() {
        return new EditVisitTask();
    }

    private Task createInProgressTask(Act act) {
        String archetype = act.getArchetype();
        TaskProperties properties = new TaskProperties();
        properties.add("status", (Object)"IN_PROGRESS");
        if (act.isA("act.customerTask")) {
            properties.add("consultStartTime", Date::new);
        }
        UpdateActTask task = new UpdateActTask(archetype, properties);
        task.skipWhenStatusIn(new String[]{"IN_PROGRESS", "BILLED", "COMPLETED"});
        return task;
    }

    private Task createBilledTask(Act act) {
        NodeConditionTask invoiceCompleted = new NodeConditionTask("act.customerAccountChargesInvoice", "status", (Object)"COMPLETED");
        UpdateActStatusTask billTask = new UpdateActStatusTask(act.getArchetype(), "BILLED");
        billTask.skipWhenStatusIn(new String[]{"COMPLETED"});
        return new ConditionalTask((EvalTask)invoiceCompleted, (Task)billTask);
    }

    private static class ClinicianSelectionTask
    extends AbstractConfirmationTask {
        public ClinicianSelectionTask(HelpContext help) {
            super(help);
        }

        protected ConfirmationDialog createConfirmationDialog(TaskContext context, HelpContext help) {
            return new ClinicianSelectionDialog((Context)context, Messages.get((String)"consult.clinician.title"), Messages.get((String)"consult.clinician.message"), help);
        }
    }

    private static class UpdateInvoiceClinicianTask
    extends UpdateClinicianTask {
        public UpdateInvoiceClinicianTask() {
            super("act.customerAccountChargesInvoice", false);
            this.skipWhenStatusIn(new String[]{"POSTED"});
        }
    }
}

