/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.consult;

import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.clinician.ClinicianReferenceEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

public class ClinicianSelectionDialog
extends ConfirmationDialog {
    private final Context context;
    private User clinician;

    public ClinicianSelectionDialog(Context context, String title, String message, HelpContext help) {
        super(title, message, help);
        this.context = context;
        this.clinician = context.getClinician();
    }

    public User getClinician() {
        return this.clinician;
    }

    protected void doLayout() {
        Label message = LabelFactory.create((boolean)true, (boolean)true);
        message.setText(this.getMessage());
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        SimpleProperty property = new SimpleProperty("clinician", Reference.class);
        property.setDisplayName(DescriptorHelper.getDisplayName((String)"act.customerAppointment", (String)"clinician", (ArchetypeService)service));
        property.setArchetypeRange(new String[]{"security.user"});
        ClinicianReferenceEditor editor = new ClinicianReferenceEditor((Property)property, null, (LayoutContext)new DefaultLayoutContext(this.context, this.getHelpContext()));
        editor.setObject(this.clinician);
        editor.addModifiableListener(modifiable -> {
            this.clinician = (User)editor.getObject();
            this.getButtons().setEnabled("ok", this.clinician != null);
        });
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{message, editor.getComponent()});
        Row row = RowFactory.create((String)"Inset.Large", (Component[])new Component[]{column});
        this.getLayout().add((Component)row);
        FocusGroup group = this.getFocusGroup();
        group.add(editor.getFocusGroup());
        group.setDefault(editor.getComponent());
        if (this.clinician != null) {
            this.setDefaultButton("ok");
        } else {
            this.getButtons().setEnabled("ok", false);
        }
        group.setFocus();
    }

    protected void onOK() {
        if (this.clinician != null) {
            this.context.setClinician(this.clinician);
            super.onOK();
        }
    }
}

