/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.archetype.i18n.time.CompositeDurationFormatter;
import org.openvpms.archetype.i18n.time.DateDurationFormatter;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.math.Weight;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientActEditor;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.workspace.patient.PatientMedicalRecordLinker;

class WeightPanel {
    private final PatientRules rules;
    private final IMObjectComponentFactory factory;
    private final IMObjectBean weightBean;
    private final Label currentWeightUnits = LabelFactory.create();
    private final SimpleProperty currentWeight;
    private final SimpleProperty currentWeightDate;
    private final Label currentWeightAge = LabelFactory.create();
    private final Map<String, String> weightUnits;
    private final WeightEditor editor;
    private final DateFormat dateFormat;
    private final Act weight;
    private static final CompositeDurationFormatter WEIGHT_AGE_FORMATTER = new CompositeDurationFormatter();
    private static final String WEIGHT = "weight";
    private static final String UNITS = "units";

    WeightPanel(LayoutContext layoutContext, IArchetypeService service, PatientRules patientRules, PracticeService practiceService) {
        this.rules = patientRules;
        this.factory = layoutContext.getComponentFactory();
        this.weightUnits = LookupNameHelper.getLookupNames((String)"act.patientWeight", (String)UNITS);
        this.weight = (Act)service.create("act.patientWeight", Act.class);
        this.weightBean = service.getBean((IMObject)this.weight);
        WeightUnits defaultUnits = practiceService.getDefaultWeightUnits();
        this.weightBean.setValue(UNITS, (Object)defaultUnits.toString());
        this.editor = new WeightEditor(this.weight, layoutContext);
        this.dateFormat = DateFormatter.getDateFormat((boolean)false);
        this.currentWeight = new SimpleProperty("currentWeight", null, BigDecimal.class, Messages.get((String)"workflow.checkin.weight.current"), true);
        this.currentWeightDate = new SimpleProperty("currentWeightDate", null, String.class, Messages.get((String)"workflow.checkin.weight.date"), true);
    }

    public void setPatient(Party patient) {
        this.editor.setPatient(patient);
        Weight weight = patient != null ? this.rules.getWeight(patient) : null;
        Date date = null;
        if (weight == null || weight.isZero()) {
            this.currentWeight.setValue(null);
            this.currentWeightUnits.setText(null);
        } else {
            this.currentWeight.setValue((Object)weight.getWeight());
            this.currentWeightUnits.setText(this.weightUnits.get(weight.getUnits().toString()));
            date = weight.getDate();
        }
        String age = null;
        if (date != null) {
            Date today = DateRules.getToday();
            if (today.equals(DateRules.getDate(date))) {
                this.currentWeightDate.setValue((Object)DateFormatter.formatTime((Date)date, (boolean)false));
            } else {
                this.currentWeightDate.setValue((Object)this.dateFormat.format(date));
                age = Messages.format((String)"workflow.checkin.weight.age", (Object[])new Object[]{WEIGHT_AGE_FORMATTER.format(date, today).toLowerCase()});
            }
        } else {
            this.currentWeightDate.setValue(null);
        }
        this.currentWeightAge.setText(age);
        this.weightBean.setTarget("patient", (IMObject)patient);
        this.editor.setWeight(null);
    }

    public void setClinician(User clinician) {
        this.editor.setClinician(clinician);
    }

    public Act getWeightRecord() {
        Act act = this.editor.getObject();
        return act != null && !act.isNew() ? act : null;
    }

    public void setWeight(BigDecimal weight) {
        this.editor.getWeight().getProperty().setValue((Object)weight);
    }

    public BigDecimal getWeight() {
        return this.editor.getWeight().getProperty().getBigDecimal();
    }

    public WeightUnits getUnits() {
        String units = this.editor.getUnits().getProperty().getString();
        return WeightUnits.fromString((String)units);
    }

    public void setUnits(WeightUnits units) {
        this.editor.getUnits().getProperty().setValue((Object)(units != null ? units.toString() : null));
    }

    public boolean validate(Validator validator) {
        return this.editor.validate(validator);
    }

    public FocusGroup layout(ComponentGrid grid) {
        int maxColumns = DateFormatter.getLength((DateFormat)this.dateFormat);
        TextField date = BoundTextComponentFactory.create((Property)this.currentWeightDate, (int)maxColumns, (Format)this.dateFormat);
        date.setStyleName("edit");
        date.setEnabled(false);
        grid.add(new Component[]{TableHelper.createSpacer()});
        grid.add(new Component[]{LabelFactory.create((String)"workflow.checkin.weight", (String)"bold")});
        grid.add(new Component[]{LabelFactory.text((String)this.currentWeight.getDisplayName()), RowFactory.create((String)"CellSpacing", (Component[])new Component[]{this.factory.create((Property)this.currentWeight), this.currentWeightUnits}), LabelFactory.text((String)this.currentWeightDate.getDisplayName()), RowFactory.create((String)"CellSpacing", (Component[])new Component[]{date, this.currentWeightAge})});
        Component weight = this.editor.getWeight().getComponent();
        Component units = this.editor.getUnits().getComponent();
        grid.add(new Component[]{LabelFactory.create((String)"workflow.checkin.weight.new"), RowFactory.create((String)"CellSpacing", (Component[])new Component[]{weight, units})});
        FocusGroup result = new FocusGroup("WeightPanel");
        result.add(weight);
        result.add(units);
        return result;
    }

    public boolean isZero() {
        return this.editor.isZero();
    }

    public void save(Act visit) {
        if (!this.isZero() && this.editor.isModified()) {
            this.weightBean.save();
            PatientMedicalRecordLinker linker = new PatientMedicalRecordLinker(visit, this.weight);
            linker.run();
        }
    }

    public boolean isWeightCurrent() {
        boolean result;
        boolean bl = result = !this.isZero();
        if (!result && !MathRules.isZero((BigDecimal)this.currentWeight.getBigDecimal(BigDecimal.ZERO))) {
            Date date = this.currentWeightDate.getDate();
            result = date != null && DateRules.compareDateToToday((Date)date) != 0;
        }
        return result;
    }

    static {
        WEIGHT_AGE_FORMATTER.add(14, DateUnits.DAYS, DateDurationFormatter.DAY);
        WEIGHT_AGE_FORMATTER.add(90, DateUnits.DAYS, DateDurationFormatter.WEEK);
        WEIGHT_AGE_FORMATTER.add(23, DateUnits.MONTHS, DateDurationFormatter.MONTH);
        WEIGHT_AGE_FORMATTER.add(2, DateUnits.YEARS, DateDurationFormatter.create((boolean)true, (boolean)true, (boolean)false, (boolean)false));
    }

    private static class WeightEditor
    extends PatientActEditor {
        WeightEditor(Act act, LayoutContext context) {
            super(act, null, context);
        }

        public PropertyEditor getWeight() {
            return (PropertyEditor)this.getEditor(WeightPanel.WEIGHT);
        }

        public PropertyEditor getUnits() {
            return (PropertyEditor)this.getEditor(WeightPanel.UNITS);
        }

        public void setWeight(BigDecimal value) {
            this.getProperty(WeightPanel.WEIGHT).setValue((Object)value);
        }

        public boolean isZero() {
            return MathRules.isZero((BigDecimal)this.getProperty(WeightPanel.WEIGHT).getBigDecimal(BigDecimal.ZERO));
        }

        protected void onLayoutCompleted() {
            super.onLayoutCompleted();
            this.getWeight().getComponent().setLayoutData(null);
            this.getUnits().getComponent().setLayoutData(null);
        }
    }
}

