/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import java.util.Date;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextException;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.query.EntityObjectSetQuery;
import org.openvpms.web.component.im.query.EntityObjectSetResultSet;
import org.openvpms.web.component.im.query.EntityQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.workflow.DefaultTaskContext;
import org.openvpms.web.component.workflow.EditIMObjectTask;
import org.openvpms.web.component.workflow.PrintIMObjectTask;
import org.openvpms.web.component.workflow.SelectIMObjectTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskProperties;
import org.openvpms.web.component.workflow.UpdateActStatusTask;
import org.openvpms.web.component.workflow.WorkflowImpl;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.checkin.AbstractPrintPatientDocumentsTask;
import org.openvpms.web.workspace.workflow.checkin.AddFlowSheetTask;

public class TransferWorkflow
extends WorkflowImpl {
    private final TaskContext initial;

    public TransferWorkflow(Act appointment, Context context, HelpContext help) {
        super(help);
        FlowSheetServiceFactory factory;
        String status = appointment.getStatus();
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)appointment);
        Party customer = (Party)bean.getTarget("customer", Party.class);
        Party patient = (Party)bean.getTarget("patient", Party.class);
        Party location = context.getLocation();
        if (customer == null) {
            throw new ContextException(ContextException.ErrorCode.NoCustomer, new Object[0]);
        }
        if (patient == null) {
            throw new ContextException(ContextException.ErrorCode.NoPatient, new Object[0]);
        }
        if (location == null) {
            throw new ContextException(ContextException.ErrorCode.NoLocation, new Object[0]);
        }
        context = LocalContext.copy((Context)context);
        context.setAppointment(appointment);
        context.setCustomer(customer);
        context.setPatient(patient);
        context.setLocation(location);
        context.setWorkList(null);
        context.setObject("act.patientClinicalEvent", null);
        this.initial = new DefaultTaskContext(context, help);
        MedicalRecordRules rules = (MedicalRecordRules)ServiceHelper.getBean(MedicalRecordRules.class);
        Act event = rules.getEvent(patient, new Date(), location);
        if (event != null) {
            context.setObject("act.patientClinicalEvent", (IMObject)event);
        }
        EntityQuery query = new EntityQuery((EntityObjectSetQuery)new WorkListQuery(location), (Context)this.initial);
        this.addTask((Task)new SelectIMObjectTask((Query)query, help.topic("worklist")));
        this.addTask((Task)new PrintPatientDocumentsTask(this.getHelpContext()));
        TaskProperties properties = new TaskProperties();
        String taskStatus = "IN_PROGRESS".equals(status) || "BILLED".equals(status) || "COMPLETED".equals(status) ? status : "IN_PROGRESS";
        properties.add("status", (Object)taskStatus);
        properties.add("startTime", Date::new);
        this.addTask((Task)new EditIMObjectTask("act.customerTask", properties, false));
        if (("IN_PROGRESS".equals(status) || "ADMITTED".equals(status)) && (factory = (FlowSheetServiceFactory)ServiceHelper.getBean(FlowSheetServiceFactory.class)).isSmartFlowSheetEnabled(location)) {
            this.addTask((Task)new AddFlowSheetTask(factory, help));
        }
        UpdateActStatusTask task = new UpdateActStatusTask(appointment.getArchetype(), "ADMITTED");
        task.skipWhenStatusIn(new String[]{"BILLED", "COMPLETED"});
        this.addTask((Task)task);
    }

    public void start() {
        super.start(this.initial);
    }

    private static class WorkListQuery
    extends EntityObjectSetQuery {
        private final Party location;
        private static final String[] SHORT_NAMES = new String[]{"party.organisationWorkList"};

        public WorkListQuery(Party location) {
            super(SHORT_NAMES);
            this.setAuto(true);
            this.location = location;
        }

        protected ResultSet<ObjectSet> createResultSet(SortConstraint[] sort) {
            return new EntityObjectSetResultSet(this.getArchetypeConstraint(), this.getValue(), this.isIdentitySearch(), sort, this.getMaxResults(), true){

                protected ArchetypeQuery createQuery() {
                    ArchetypeQuery query = super.createQuery();
                    ObjectRefConstraint locationFilter = new ObjectRefConstraint("location", location.getObjectReference());
                    locationFilter.add((IConstraint)Constraints.join((String)"workListViews").add((IConstraint)Constraints.join((String)"target", (String)"wlv").add((IConstraint)Constraints.join((String)"workLists", (String)"wl").add((IConstraint)Constraints.idEq((String)"wl.target", (String)"entity")))));
                    query.add((IConstraint)locationFilter);
                    return query;
                }
            };
        }
    }

    private static class PrintPatientDocumentsTask
    extends AbstractPrintPatientDocumentsTask {
        public PrintPatientDocumentsTask(HelpContext help) {
            super(PrintIMObjectTask.PrintMode.DEFAULT, help);
            this.setRequired(false);
        }

        @Override
        protected Entity getWorkList(TaskContext context) {
            return context.getWorkList();
        }

        @Override
        protected Entity getSchedule(TaskContext context) {
            return null;
        }
    }
}

