/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import java.math.BigDecimal;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.math.Weight;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.ContextException;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.retry.Retryable;
import org.openvpms.web.component.retry.Retryer;
import org.openvpms.web.component.workflow.ConditionalTask;
import org.openvpms.web.component.workflow.DeleteIMObjectTask;
import org.openvpms.web.component.workflow.EditIMObjectTask;
import org.openvpms.web.component.workflow.EvalTask;
import org.openvpms.web.component.workflow.NodeConditionTask;
import org.openvpms.web.component.workflow.SynchronousTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskProperties;
import org.openvpms.web.component.workflow.Tasks;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.event.Vetoable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.PatientMedicalRecordLinker;
import org.openvpms.web.workspace.workflow.checkin.CheckInHelper;

class PatientWeightTask
extends Tasks {
    private final boolean useContext;
    private BigDecimal weight;
    private String units;
    private static final String PATIENT_WEIGHT = "act.patientWeight";

    public PatientWeightTask(HelpContext help) {
        this(null, true, help);
    }

    public PatientWeightTask(Weight weight, HelpContext help) {
        this(weight, false, help);
    }

    private PatientWeightTask(Weight weight, boolean useContext, HelpContext help) {
        super(help);
        if (weight != null) {
            this.weight = weight.getWeight();
            this.units = weight.getUnits().toString();
        }
        this.useContext = useContext;
        this.setRequired(false);
        this.setBreakOnSkip(true);
    }

    protected void initialise(TaskContext context) {
        boolean inputWeight;
        boolean createFlowSheet;
        if (this.useContext) {
            Party schedule = context.getSchedule();
            Entity worklist = CheckInHelper.getWorkList(context);
            createFlowSheet = this.createFlowSheet(worklist);
            inputWeight = createFlowSheet || this.inputWeight((Entity)schedule) || this.inputWeight(worklist);
        } else {
            createFlowSheet = true;
            inputWeight = true;
        }
        if (inputWeight) {
            this.initLastWeight(context);
            TaskProperties properties = new TaskProperties();
            properties.add("weight", () -> this.weight);
            properties.add("units", () -> this.units);
            EditWeightTask editWeightTask = new EditWeightTask(properties, createFlowSheet);
            this.addTask((Task)editWeightTask);
            NodeConditionTask weightZero = new NodeConditionTask(PATIENT_WEIGHT, "weight", false, (Object)BigDecimal.ZERO);
            DeleteIMObjectTask deleteWeightTask = new DeleteIMObjectTask(PATIENT_WEIGHT);
            ConditionalTask condition = new ConditionalTask((EvalTask)weightZero, (Task)new WeightLinkerTask(), (Task)deleteWeightTask);
            this.addTask((Task)condition);
        } else {
            this.notifySkipped();
        }
    }

    private boolean inputWeight(Entity schedule) {
        return schedule != null && this.getBean((IMObject)schedule).getBoolean("inputWeight", true);
    }

    private boolean createFlowSheet(Entity workList) {
        return workList != null && this.getBean((IMObject)workList).getBoolean("createFlowSheet");
    }

    private void initLastWeight(TaskContext context) {
        if (this.weight == null) {
            Act act = this.queryLastWeight(context);
            if (act != null) {
                IMObjectBean bean = this.getBean((IMObject)act);
                this.weight = bean.getBigDecimal("weight");
                this.units = bean.getString("units");
            } else {
                this.weight = BigDecimal.ZERO;
                IArchetypeRuleService service = ServiceHelper.getArchetypeService();
                act = (Act)service.create(PATIENT_WEIGHT, Act.class);
                IMObjectBean bean = this.getBean((IMObject)act);
                Object value = bean.getDefaultValue("weight");
                this.units = value != null ? value.toString() : WeightUnits.KILOGRAMS.toString();
            }
        }
    }

    private Act queryLastWeight(TaskContext context) {
        PatientRules rules = (PatientRules)ServiceHelper.getBean(PatientRules.class);
        Party patient = context.getPatient();
        if (patient == null) {
            throw new ContextException(ContextException.ErrorCode.NoPatient, new Object[0]);
        }
        return rules.getWeightAct(patient);
    }

    private static class WeightLinkerTask
    extends SynchronousTask {
        private WeightLinkerTask() {
        }

        public void execute(TaskContext context) {
            Act weight;
            Act event = (Act)context.getObject("act.patientClinicalEvent");
            PatientMedicalRecordLinker linker = new PatientMedicalRecordLinker(event, weight = (Act)context.getObject(PatientWeightTask.PATIENT_WEIGHT));
            if (Retryer.run((Retryable)linker)) {
                context.setObject("act.patientClinicalEvent", (IMObject)event);
                this.notifyCompleted();
            } else {
                this.notifyCancelled();
            }
        }
    }

    private class EditWeightTask
    extends EditIMObjectTask {
        private final boolean createFlowSheet;

        public EditWeightTask(TaskProperties properties, boolean createFlowSheet) {
            super(PatientWeightTask.PATIENT_WEIGHT, properties, true);
            this.setRequired(false);
            this.setSkip(true);
            this.setDeleteOnCancelOrSkip(true);
            this.createFlowSheet = createFlowSheet;
        }

        protected EditDialog createEditDialog(IMObjectEditor editor, boolean skip, TaskContext context) {
            EditDialog dialog = super.createEditDialog(editor, skip, context);
            if (this.createFlowSheet) {
                dialog.setSkipListener(this::confirmSkip);
            }
            return dialog;
        }

        private void confirmSkip(final Vetoable action) {
            String title = Messages.get((String)"workflow.checkin.skipweight.title");
            String message = !MathRules.isZero((BigDecimal)PatientWeightTask.this.weight) ? Messages.get((String)"workflow.checkin.skipweight.previous") : Messages.get((String)"workflow.checkin.skipweight.none");
            ConfirmationDialog dialog = new ConfirmationDialog(title, message, PopupDialog.YES_NO);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    action.veto(false);
                }

                public void onNo() {
                    action.veto(true);
                }
            });
            dialog.show();
        }
    }
}

