/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.workspace.workflow.appointment.repeat.CalendarRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.CalendarRepeatExpressionViewer;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatHelper;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnDateEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnDateViewer;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnDaysEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnDaysOfMonthEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnDaysOfMonthViewer;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnDaysViewer;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnNthDayEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnNthDayInMonthEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnNthDayInMonthViewer;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnNthDayViewer;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnWeekdaysEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeries;

public class ScheduleEventSeriesViewer {
    private final ScheduleEventSeries series;

    public ScheduleEventSeriesViewer(ScheduleEventSeries series) {
        this.series = series;
    }

    public Component getComponent() {
        Label result;
        RepeatExpression expression = this.series.getExpression();
        RepeatCondition condition = this.series.getCondition();
        if (expression == null) {
            result = LabelFactory.create((String)"workflow.scheduling.appointment.norepeat");
        } else {
            Label conditionComponent = LabelFactory.create();
            Object expressionComponent = expression instanceof CalendarRepeatExpression ? this.getExpression((CalendarRepeatExpression)expression) : (expression instanceof CronRepeatExpression ? this.getExpression((CronRepeatExpression)expression) : LabelFactory.create());
            if (condition != null) {
                conditionComponent.setText(condition.toString());
            }
            result = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{expressionComponent, conditionComponent});
        }
        return result;
    }

    private Component getExpression(CronRepeatExpression expression) {
        Object result;
        if (RepeatOnWeekdaysEditor.supports(expression)) {
            Label label = LabelFactory.create();
            label.setText(RepeatHelper.toString(RepeatExpression.Type.WEEKDAYS));
            result = label;
        } else {
            result = RepeatOnDaysEditor.supports(expression) ? new RepeatOnDaysViewer(expression).getComponent() : (RepeatOnNthDayEditor.supports(expression) ? new RepeatOnNthDayViewer(expression).getComponent() : (RepeatOnDaysOfMonthEditor.supports(expression) ? new RepeatOnDaysOfMonthViewer(expression).getComponent() : (RepeatOnDateEditor.supports(expression) ? new RepeatOnDateViewer(expression).getComponent() : (RepeatOnNthDayInMonthEditor.supports(expression) ? new RepeatOnNthDayInMonthViewer(expression).getComponent() : LabelFactory.create()))));
        }
        return result;
    }

    private Component getExpression(CalendarRepeatExpression expression) {
        CalendarRepeatExpressionViewer viewer = new CalendarRepeatExpressionViewer(expression);
        Component result = viewer.getComponent();
        return result;
    }
}

