/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import echopointng.BorderEx;
import echopointng.TabbedPane;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.button.ButtonGroup;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.AbstractTableModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableModel;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.property.AbstractModifiable;
import org.openvpms.web.component.property.ErrorListener;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.ModifiableListeners;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.TabbedPaneFactory;
import org.openvpms.web.echo.factory.TableFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.popup.DropDown;
import org.openvpms.web.echo.table.KeyTable;
import org.openvpms.web.echo.table.StyleTableCellRenderer;
import org.openvpms.web.echo.tabpane.ObjectTabPaneModel;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractRepeatExpressionEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractRepeatUntilEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.CalendarRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatEveryEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpressionEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatNTimesCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatNTimesEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnDateEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnDaysEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnDaysOfMonthEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnNthDayEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnNthDayInMonthEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnWeekdaysEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatUntilDateCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatUntilDateEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatUntilEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.Repeats;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeries;
import org.openvpms.web.workspace.workflow.appointment.repeat.SimpleRepeatEditor;

public class ScheduleEventSeriesEditor
extends AbstractModifiable {
    private final ScheduleEventSeries series;
    private final int maxRepeats;
    private final FocusGroup repeatGroup = new FocusGroup(RepeatExpressionEditor.class.getSimpleName());
    private final FocusGroup untilGroup = new FocusGroup(RepeatUntilEditor.class.getSimpleName());
    private final ModifiableListeners listeners = new ModifiableListeners();
    private final ModifiableListener listener;
    private Component repeatContainer;
    private DropDown repeatSelector;
    private RepeatExpressionEditor repeatEditor;
    private ObjectTabPaneModel<ExpressionTab> repeatModel;
    private Component untilContainer;
    private DropDown untilSelector;
    private RepeatUntilEditor untilEditor;
    private Table untilTable;

    public ScheduleEventSeriesEditor(ScheduleEventSeries series) {
        this.maxRepeats = series.getMaxEvents() - 1;
        this.series = series;
        this.listener = new ModifiableListener(){

            public void modified(Modifiable modifiable) {
                ScheduleEventSeriesEditor.this.resetValid(false);
                ScheduleEventSeriesEditor.this.listeners.notifyListeners(modifiable);
            }
        };
        this.setExpression(series.getExpression());
        this.setCondition(series.getCondition());
    }

    public void setExpression(RepeatExpression expression) {
        AbstractRepeatExpressionEditor editor = null;
        if (expression instanceof CalendarRepeatExpression) {
            CalendarRepeatExpression calendar = (CalendarRepeatExpression)expression;
            editor = calendar.getInterval() == 1 ? new SimpleRepeatEditor(calendar) : new RepeatEveryEditor(calendar);
        } else if (expression instanceof CronRepeatExpression) {
            CronRepeatExpression cron = (CronRepeatExpression)expression;
            if (RepeatOnWeekdaysEditor.supports(cron)) {
                editor = new RepeatOnWeekdaysEditor();
            } else if (RepeatOnDaysEditor.supports(cron)) {
                editor = new RepeatOnDaysEditor(cron);
            } else if (RepeatOnNthDayEditor.supports(cron)) {
                editor = new RepeatOnNthDayEditor(cron);
            } else if (RepeatOnDaysOfMonthEditor.supports(cron)) {
                editor = new RepeatOnDaysOfMonthEditor(cron);
            } else if (RepeatOnDateEditor.supports(cron)) {
                editor = new RepeatOnDateEditor(cron);
            } else if (RepeatOnNthDayInMonthEditor.supports(cron)) {
                editor = new RepeatOnNthDayInMonthEditor(cron);
            }
        }
        this.setRepeatEditor(editor);
    }

    public void setCondition(RepeatCondition condition) {
        AbstractRepeatUntilEditor editor = null;
        if (condition instanceof RepeatUntilDateCondition) {
            editor = new RepeatUntilDateEditor((RepeatUntilDateCondition)condition);
        } else if (condition instanceof RepeatNTimesCondition) {
            editor = new RepeatNTimesEditor((RepeatNTimesCondition)condition, this.maxRepeats);
        }
        this.setUntilEditor(editor);
    }

    public ScheduleEventSeries getSeries() {
        this.updateSeries();
        return this.series;
    }

    public void refresh() {
        this.updateSeries();
        this.refreshRepeat();
    }

    public Component getRepeatEditor() {
        if (this.repeatContainer == null) {
            this.repeatContainer = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
            if (this.repeatSelector == null) {
                this.repeatModel = this.createRepeatModel();
                TabbedPane tabs = TabbedPaneFactory.create(this.repeatModel);
                this.repeatSelector = this.createDropDown(null, (Component)RowFactory.create((Component[])new Component[]{tabs}));
                this.repeatSelector.setBorder((Border)BorderEx.NONE);
                this.repeatSelector.setRolloverBorder((Border)BorderEx.NONE);
                this.repeatSelector.setPopUpAlwaysOnTop(true);
                this.repeatSelector.setFocusOnExpand(true);
            }
            Label component = this.repeatEditor == null ? LabelFactory.create((String)"workflow.scheduling.appointment.norepeat") : this.repeatEditor.getComponent();
            this.repeatContainer.add((Component)component);
            this.repeatContainer.add((Component)this.repeatSelector);
        }
        return this.repeatContainer;
    }

    public FocusGroup getRepeatFocusGroup() {
        return this.repeatGroup;
    }

    public Component getUntilEditor() {
        if (this.untilContainer == null) {
            this.untilContainer = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
            if (this.untilEditor != null) {
                this.untilContainer.add(this.untilEditor.getComponent());
                this.untilContainer.add(this.getUntilSelector());
            }
        }
        return this.untilContainer;
    }

    public FocusGroup getUntilFocusGroup() {
        return this.untilGroup;
    }

    public boolean isModified() {
        return this.series.isModified();
    }

    public void clearModified() {
    }

    public void addModifiableListener(ModifiableListener listener) {
        this.listeners.addListener(listener);
    }

    public void addModifiableListener(ModifiableListener listener, int index) {
        this.listeners.addListener(listener, index);
    }

    public void removeModifiableListener(ModifiableListener listener) {
        this.listeners.removeListener(listener);
    }

    public void setErrorListener(ErrorListener listener) {
    }

    public ErrorListener getErrorListener() {
        return null;
    }

    public void save() {
        this.series.save();
    }

    protected boolean doValidation(Validator validator) {
        boolean valid = false;
        this.updateSeries();
        if (this.repeatEditor != null) {
            if (this.untilEditor != null) {
                valid = this.repeatEditor.validate(validator) && this.untilEditor.validate(validator) && this.noOverlaps(validator);
            }
        } else {
            valid = true;
        }
        return valid;
    }

    protected void updateSeries() {
        this.series.refresh();
        if (this.repeatEditor != null) {
            this.repeatEditor.setStartTime(this.series.getStartTime());
            this.series.setExpression(this.repeatEditor.getExpression());
        } else {
            this.series.setExpression(null);
        }
        if (this.untilEditor != null) {
            this.series.setCondition(this.untilEditor.getCondition());
        } else {
            this.series.setCondition(null);
        }
    }

    private boolean noOverlaps(Validator validator) {
        boolean result;
        ScheduleEventSeries.Overlap overlap = this.series.getFirstOverlap();
        if (overlap != null) {
            result = false;
            Times event1 = overlap.getEvent1();
            Times event2 = overlap.getEvent2();
            String displayName = DescriptorHelper.getDisplayName((IMObject)this.series.getEvent(), (ArchetypeService)ServiceHelper.getArchetypeService());
            String startTime1 = DateFormatter.formatDateTime((Date)event1.getStartTime());
            String endTime1 = DateFormatter.formatDateTimeAbbrev((Date)event1.getEndTime(), (Date)event1.getStartTime());
            String startTime2 = DateFormatter.formatDateTime((Date)event2.getStartTime());
            String endTime2 = DateFormatter.formatDateTimeAbbrev((Date)event2.getEndTime(), (Date)event2.getStartTime());
            String message = Messages.format((String)"workflow.scheduling.appointment.overlap", (Object[])new Object[]{displayName, startTime1, endTime1, startTime2, endTime2});
            validator.add((Modifiable)this, new ValidatorError(message));
        } else {
            result = true;
        }
        return result;
    }

    private Component getUntilSelector() {
        if (this.untilSelector == null) {
            this.untilTable = ScheduleEventSeriesEditor.createTable((TableModel)this.createUntilModel());
            if (this.untilEditor == null) {
                this.untilEditor = new RepeatUntilDateEditor(DateRules.getDate((Date)this.series.getStartTime(), (int)1, (DateUnits)DateUnits.YEARS));
            }
            this.untilSelector = this.createDropDown(null, (Component)this.untilTable);
        }
        return this.untilSelector;
    }

    private void onSelected(RepeatExpressionEditor editor) {
        this.repeatSelector.setExpanded(false);
        this.setRepeatEditor(editor);
        this.refreshRepeat();
        this.listeners.notifyListeners((Modifiable)this);
    }

    private void setRepeatEditor(RepeatExpressionEditor editor) {
        if (this.repeatEditor != null) {
            this.repeatEditor.removeModifiableListener(this.listener);
            this.repeatGroup.remove(this.repeatEditor.getFocusGroup());
        }
        this.repeatEditor = editor;
        if (this.repeatContainer != null) {
            this.repeatContainer.removeAll();
            if (this.repeatEditor != null) {
                this.repeatContainer.add(this.repeatEditor.getComponent());
                this.repeatGroup.add(this.repeatEditor.getFocusGroup());
                this.repeatContainer.add((Component)this.repeatSelector);
                this.repeatEditor.addModifiableListener(this.listener);
                if (this.untilEditor == null) {
                    this.setUntilEditor(new RepeatNTimesEditor(null, this.maxRepeats));
                }
            } else {
                this.repeatContainer.add((Component)LabelFactory.create((String)"workflow.scheduling.appointment.norepeat"));
                this.setUntilEditor(null);
            }
            this.repeatContainer.add((Component)this.repeatSelector);
        }
        this.resetValid();
    }

    private void onSelected(RepeatUntilEditor editor) {
        this.untilSelector.setExpanded(false);
        this.setUntilEditor(editor);
        this.refreshUntil();
        this.listeners.notifyListeners((Modifiable)this);
    }

    private void setUntilEditor(RepeatUntilEditor editor) {
        if (this.untilEditor != null) {
            this.untilEditor.removeModifiableListener(this.listener);
            this.untilGroup.remove(this.untilEditor.getFocusGroup());
        }
        this.untilEditor = editor;
        if (this.untilContainer != null) {
            this.untilContainer.removeAll();
            if (this.untilEditor != null) {
                this.untilEditor.addModifiableListener(this.listener);
                this.untilContainer.add(this.untilEditor.getComponent());
                this.untilGroup.add(this.untilEditor.getFocusGroup());
                this.untilContainer.add(this.getUntilSelector());
            }
        }
        this.resetValid();
    }

    private void refreshRepeat() {
        if (this.repeatModel != null) {
            for (int i = 0; i < this.repeatModel.size(); ++i) {
                ((ExpressionTab)this.repeatModel.getObject(i)).refresh();
            }
        }
    }

    private void refreshUntil() {
        if (this.untilTable != null) {
            this.untilTable.setModel((TableModel)this.createUntilModel());
        }
    }

    private DropDown createDropDown(Component target, Component dropDown) {
        DropDown result = new DropDown(target, dropDown);
        result.setBorder((Border)BorderEx.NONE);
        result.setRolloverBorder((Border)BorderEx.NONE);
        result.setPopUpAlwaysOnTop(true);
        result.setFocusOnExpand(true);
        return result;
    }

    private ObjectTabPaneModel<ExpressionTab> createRepeatModel() {
        ObjectTabPaneModel model = new ObjectTabPaneModel(null);
        this.addTab((ObjectTabPaneModel<ExpressionTab>)model, new Daily());
        this.addTab((ObjectTabPaneModel<ExpressionTab>)model, new Weekly());
        this.addTab((ObjectTabPaneModel<ExpressionTab>)model, new Monthly());
        this.addTab((ObjectTabPaneModel<ExpressionTab>)model, new Yearly());
        return model;
    }

    private void addTab(ObjectTabPaneModel<ExpressionTab> model, ExpressionTab tab) {
        model.addTab((Object)tab, tab.getDisplayName(), tab.getComponent());
    }

    private UntilTableModel createUntilModel() {
        UntilTableModel model = new UntilTableModel();
        model.add(Messages.get((String)"workflow.scheduling.appointment.once"), new RepeatNTimesEditor(1, this.maxRepeats));
        model.add(Messages.get((String)"workflow.scheduling.appointment.twice"), new RepeatNTimesEditor(2, this.maxRepeats));
        model.add(new RepeatNTimesEditor(null, this.maxRepeats));
        model.add(new RepeatUntilDateEditor(DateRules.getDate((Date)this.series.getStartTime(), (int)1, (DateUnits)DateUnits.YEARS)));
        return model;
    }

    private static Table createTable(TableModel model) {
        KeyTable table = TableFactory.create((TableModel)model, (String)"plain");
        table.setHeaderVisible(false);
        table.setInsets(new Insets(10));
        table.setDefaultRenderer(Object.class, (TableCellRenderer)new StyleTableCellRenderer("Table.Row-Inset"));
        table.setSelectionEnabled(false);
        table.setRolloverEnabled(false);
        return table;
    }

    private class UntilTableModel
    extends ButtonTableModel {
        private UntilTableModel() {
        }

        public RadioButton add(String displayName, RepeatUntilEditor editor) {
            Label label = LabelFactory.create();
            label.setText(displayName);
            return this.add(editor, (Component)label);
        }

        public RadioButton add(RepeatUntilEditor until) {
            return this.add(until, until.getComponent());
        }

        private RadioButton add(final RepeatUntilEditor editor, Component component) {
            RadioButton button = this.add(component);
            button.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    ScheduleEventSeriesEditor.this.onSelected(editor);
                }
            });
            return button;
        }
    }

    private class Yearly
    extends ExpressionTab {
        public Yearly() {
            super(Messages.get((String)"workflow.scheduling.appointment.yearly"));
        }

        @Override
        protected RepeatTableModel createTableModel() {
            RepeatTableModel model = new RepeatTableModel();
            model.add(new SimpleRepeatEditor(Repeats.yearly()));
            model.add(new RepeatEveryEditor(DateUnits.YEARS));
            model.add(new RepeatOnDateEditor(ScheduleEventSeriesEditor.this.series.getStartTime()));
            model.add(new RepeatOnNthDayInMonthEditor(ScheduleEventSeriesEditor.this.series.getStartTime()));
            return model;
        }
    }

    private class Monthly
    extends ExpressionTab {
        public Monthly() {
            super(Messages.get((String)"workflow.scheduling.appointment.monthly"));
        }

        @Override
        protected RepeatTableModel createTableModel() {
            RepeatTableModel model = new RepeatTableModel();
            model.add(new SimpleRepeatEditor(Repeats.monthly()));
            model.add(new RepeatEveryEditor(DateUnits.MONTHS));
            model.add(new RepeatOnNthDayEditor(ScheduleEventSeriesEditor.this.series.getStartTime()));
            model.add(new RepeatOnDaysOfMonthEditor(ScheduleEventSeriesEditor.this.series.getStartTime()));
            return model;
        }
    }

    private class Weekly
    extends ExpressionTab {
        public Weekly() {
            super(Messages.get((String)"workflow.scheduling.appointment.weekly"));
        }

        @Override
        protected RepeatTableModel createTableModel() {
            RepeatTableModel model = new RepeatTableModel();
            model.add(new SimpleRepeatEditor(Repeats.weekly()));
            model.add(new RepeatEveryEditor(DateUnits.WEEKS));
            return model;
        }
    }

    private class Daily
    extends ExpressionTab {
        public Daily() {
            super(Messages.get((String)"workflow.scheduling.appointment.daily"));
        }

        @Override
        protected RepeatTableModel createTableModel() {
            RepeatTableModel model = new RepeatTableModel();
            if (ScheduleEventSeriesEditor.this.repeatEditor != null) {
                RadioButton noRepeat = model.add((Component)LabelFactory.create((String)"workflow.scheduling.appointment.norepeat"));
                noRepeat.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                    public void onAction(ActionEvent event) {
                        ScheduleEventSeriesEditor.this.onSelected(null);
                    }
                });
            }
            model.add(new SimpleRepeatEditor(Repeats.daily()));
            model.add(new RepeatOnWeekdaysEditor());
            model.add(new RepeatEveryEditor(DateUnits.DAYS));
            model.add(new RepeatOnDaysEditor(ScheduleEventSeriesEditor.this.series.getStartTime()));
            return model;
        }
    }

    private abstract class ExpressionTab {
        private final String displayName;
        private final Table table;

        public ExpressionTab(String displayName) {
            this.displayName = displayName;
            this.table = ScheduleEventSeriesEditor.createTable((TableModel)this.createTableModel());
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Component getComponent() {
            return this.table;
        }

        public void refresh() {
            this.table.setModel((TableModel)this.createTableModel());
        }

        protected abstract RepeatTableModel createTableModel();
    }

    private class RepeatTableModel
    extends ButtonTableModel {
        private RepeatTableModel() {
        }

        public RadioButton add(final RepeatExpressionEditor repeat) {
            RadioButton button = super.add(repeat.getComponent());
            button.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    ScheduleEventSeriesEditor.this.onSelected(repeat);
                }
            });
            return button;
        }
    }

    private static class ButtonTableModel
    extends AbstractTableModel {
        private final ButtonGroup group = new ButtonGroup();
        private List<RadioButton> buttons = new ArrayList<RadioButton>();
        private List<Component> components = new ArrayList<Component>();

        private ButtonTableModel() {
        }

        public RadioButton add(Component component) {
            RadioButton button = new RadioButton();
            button.setGroup(this.group);
            this.buttons.add(button);
            this.components.add(component);
            return button;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.components.size();
        }

        public Object getValueAt(int column, int row) {
            switch (column) {
                case 0: {
                    return this.buttons.get(row);
                }
                case 1: {
                    return this.components.get(row);
                }
            }
            return null;
        }
    }
}

