/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Date;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.web.workspace.workflow.appointment.repeat.CalendarRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatNTimesCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatUntilDateCondition;

public class Repeats {
    public static RepeatExpression daily() {
        return new CalendarRepeatExpression(1, DateUnits.DAYS);
    }

    public static RepeatExpression weekly() {
        return new CalendarRepeatExpression(1, DateUnits.WEEKS);
    }

    public static RepeatExpression monthly() {
        return new CalendarRepeatExpression(1, DateUnits.MONTHS);
    }

    public static RepeatExpression yearly() {
        return new CalendarRepeatExpression(1, DateUnits.YEARS);
    }

    public static RepeatExpression weekdays(Date startTime) {
        return CronRepeatExpression.weekdays(startTime);
    }

    public static RepeatCondition once() {
        return Repeats.times(1);
    }

    public static RepeatCondition twice() {
        return Repeats.times(2);
    }

    public static RepeatCondition times(int times) {
        return new RepeatNTimesCondition(times);
    }

    public static RepeatCondition until(Date date) {
        return new RepeatUntilDateCondition(date);
    }
}

