/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.layout.GridLayoutData;
import org.joda.time.DateTime;
import org.openvpms.web.component.bound.SpinBox;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.button.ToggleButton;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractRepeatExpressionEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;

class RepeatOnDaysOfMonthEditor
extends AbstractRepeatExpressionEditor {
    private final ToggleButton[] days = new ToggleButton[31];
    private final ToggleButton lastDay;
    private final SimpleProperty interval = new SimpleProperty("interval", null, Integer.class, Messages.get((String)"workflow.scheduling.appointment.interval"));

    public RepeatOnDaysOfMonthEditor(Date startTime) {
        super(startTime);
        this.interval.setRequired(true);
        for (int i = 0; i < this.days.length; ++i) {
            int day = i + 1;
            ToggleButton button = new ToggleButton("" + day, false);
            button.setAlignment(Alignment.ALIGN_RIGHT);
            this.days[i] = button;
        }
        this.lastDay = new ToggleButton(Messages.get((String)"workflow.scheduling.appointment.lastday"));
        if (startTime != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(startTime);
            this.days[calendar.get(5) - 1].setSelected(true);
        }
        this.interval.setValue((Object)1);
    }

    public RepeatOnDaysOfMonthEditor(CronRepeatExpression expression) {
        this((Date)null);
        CronRepeatExpression.DayOfMonth dayOfMonth = expression.getDayOfMonth();
        for (int i = 0; i < this.days.length; ++i) {
            int day = i + 1;
            if (!dayOfMonth.isSelected(day)) continue;
            this.days[i].setSelected(true);
        }
        if (dayOfMonth.hasLast()) {
            this.lastDay.setSelected(true);
        }
        this.interval.setValue((Object)expression.getMonth().getInterval());
    }

    @Override
    public Component getComponent() {
        Grid grid = new Grid(7);
        grid.setInsets(new Insets(1));
        FocusGroup group = this.getFocusGroup();
        for (ToggleButton day : this.days) {
            grid.add((Component)day);
            group.add((Component)day);
        }
        GridLayoutData layout = new GridLayoutData();
        layout.setColumnSpan(4);
        this.lastDay.setLayoutData((LayoutData)layout);
        this.lastDay.setAlignment(Alignment.ALIGN_CENTER);
        grid.add((Component)this.lastDay);
        Label onthe = LabelFactory.create((String)"workflow.scheduling.appointment.onthe");
        Label every = LabelFactory.create();
        every.setText(Messages.get((String)"workflow.scheduling.appointment.every").toLowerCase());
        SpinBox intervalField = new SpinBox((Property)this.interval, 1, 12);
        Label months = LabelFactory.create((String)"workflow.scheduling.appointment.months");
        return RowFactory.create((String)"CellSpacing", (Component[])new Component[]{onthe, grid, every, intervalField, months});
    }

    public static boolean supports(CronRepeatExpression expression) {
        CronRepeatExpression.DayOfWeek dayOfWeek = expression.getDayOfWeek();
        CronRepeatExpression.DayOfMonth dayOfMonth = expression.getDayOfMonth();
        CronRepeatExpression.Month month = expression.getMonth();
        return dayOfWeek.isAll() && !dayOfMonth.isAll() && month.getInterval() != -1;
    }

    @Override
    public RepeatExpression getExpression() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Date startTime = this.getStartTime();
        if (startTime != null) {
            for (int i = 0; i < this.days.length; ++i) {
                boolean selected = this.days[i].isSelected();
                if (!selected) continue;
                list.add(i + 1);
            }
            boolean last = this.lastDay.isSelected();
            if (!list.isEmpty() || last) {
                CronRepeatExpression.DayOfMonth dayOfMonth = CronRepeatExpression.DayOfMonth.days(list, last);
                DateTime time = new DateTime((Object)startTime);
                return new CronRepeatExpression(startTime, dayOfMonth, CronRepeatExpression.Month.every(time.getMonthOfYear(), this.interval.getInt()));
            }
        }
        return null;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return this.validateDays(validator) && this.interval.validate(validator);
    }

    private boolean validateDays(Validator validator) {
        boolean result = this.lastDay.isSelected();
        if (!result) {
            for (ToggleButton button : this.days) {
                if (!button.isSelected()) continue;
                result = true;
                break;
            }
        }
        if (!result) {
            validator.add((Modifiable)this, new ValidatorError(Messages.get((String)"workflow.scheduling.appointment.selectdays")));
        }
        return result;
    }
}

