/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Date;
import java.util.GregorianCalendar;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.joda.time.DateTime;
import org.openvpms.web.component.bound.SpinBox;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractRepeatExpressionEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.MonthSelectField;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;

class RepeatOnDateEditor
extends AbstractRepeatExpressionEditor {
    private SimpleProperty day = new SimpleProperty("day", Integer.class);
    private SimpleProperty month = new SimpleProperty("month", Integer.class);
    private SimpleProperty interval = new SimpleProperty("interval", Integer.class);

    public RepeatOnDateEditor(Date startTime) {
        super(startTime);
        this.day.setRequired(true);
        this.interval.setRequired(true);
        this.month.setRequired(true);
        if (startTime != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(startTime);
            this.day.setValue((Object)calendar.get(5));
            this.month.setValue((Object)(calendar.get(2) + 1));
        }
        this.interval.setValue((Object)1);
    }

    public RepeatOnDateEditor(CronRepeatExpression expression) {
        this((Date)null);
        CronRepeatExpression.Year year;
        int selectedMonth;
        CronRepeatExpression.DayOfMonth dayOfMonth = expression.getDayOfMonth();
        int selectedDay = dayOfMonth.day();
        if (selectedDay != -1) {
            this.day.setValue((Object)selectedDay);
        }
        if ((selectedMonth = expression.getMonth().month()) != -1) {
            this.month.setValue((Object)selectedMonth);
        }
        if ((year = expression.getYear()).getInterval() != -1) {
            this.interval.setValue((Object)year.getInterval());
        }
    }

    @Override
    public Component getComponent() {
        FocusGroup group = this.getFocusGroup();
        SpinBox dayField = new SpinBox((Property)this.day, 1, 31);
        MonthSelectField monthField = new MonthSelectField((Property)this.month);
        SpinBox intervalField = new SpinBox((Property)this.interval, 1, 10);
        group.add((Component)dayField);
        group.add((Component)monthField);
        group.add((Component)intervalField);
        Label every = LabelFactory.create();
        every.setText(Messages.get((String)"workflow.scheduling.appointment.every").toLowerCase());
        Label years = LabelFactory.create();
        years.setText(Messages.get((String)"workflow.scheduling.appointment.years"));
        return RowFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.create((String)"workflow.scheduling.appointment.onthe"), dayField, monthField, every, intervalField, years});
    }

    public static boolean supports(CronRepeatExpression expression) {
        CronRepeatExpression.DayOfWeek dayOfWeek = expression.getDayOfWeek();
        CronRepeatExpression.DayOfMonth dayOfMonth = expression.getDayOfMonth();
        CronRepeatExpression.Month month = expression.getMonth();
        CronRepeatExpression.Year year = expression.getYear();
        return dayOfWeek.isAll() && dayOfMonth.singleDay() && month.singleMonth() && year.getInterval() != -1;
    }

    @Override
    public RepeatExpression getExpression() {
        Date startTime = this.getStartTime();
        if (startTime != null) {
            CronRepeatExpression.DayOfMonth dayOfMonth = CronRepeatExpression.DayOfMonth.day(this.day.getInt());
            DateTime time = new DateTime((Object)startTime);
            return new CronRepeatExpression(startTime, dayOfMonth, CronRepeatExpression.Month.month(this.month.getInt()), CronRepeatExpression.Year.every(time.getYear(), this.interval.getInt()));
        }
        return null;
    }
}

