/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.reminder;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.sms.SMSTemplateEvaluator;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.reminder.AppointmentReminderException;

public class AppointmentReminderEvaluator {
    private final ArchetypeService service;
    private final SMSTemplateEvaluator evaluator;

    public AppointmentReminderEvaluator(ArchetypeService service, SMSTemplateEvaluator evaluator) {
        this.service = service;
        this.evaluator = evaluator;
    }

    public String evaluate(Entity template, Act appointment, Party location, Party practice) {
        String result;
        LocalContext context = new LocalContext();
        IMObjectBean bean = this.service.getBean((IMObject)appointment);
        context.setCustomer((Party)bean.getTarget("customer", Party.class));
        context.setPatient((Party)bean.getTarget("patient", Party.class));
        context.setLocation(location);
        context.setPractice(practice);
        context.addObject((IMObject)appointment);
        try {
            result = this.evaluator.evaluate(template, (Object)appointment, (Context)context);
        }
        catch (Throwable exception) {
            throw new AppointmentReminderException(Messages.format((String)"reporting.reminder.smsevaluatefailed", (Object[])new Object[]{template.getName()}), exception);
        }
        return result;
    }
}

