/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.boarding;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.workspace.workflow.appointment.AbstractMultiDayScheduleGrid;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;

public class CheckOutScheduleGrid
extends AbstractMultiDayScheduleGrid {
    public CheckOutScheduleGrid(Entity scheduleView, Date date, int days, Map<Entity, ScheduleEvents> events, AppointmentRules rules) {
        super(scheduleView, date, days, CheckOutScheduleGrid.filterEvents(events, date), rules);
    }

    private static Map<Entity, ScheduleEvents> filterEvents(Map<Entity, ScheduleEvents> events, Date date) {
        LinkedHashMap<Entity, ScheduleEvents> map = new LinkedHashMap<Entity, ScheduleEvents>();
        for (Map.Entry<Entity, ScheduleEvents> eventsBySchedule : events.entrySet()) {
            Date midnight = DateRules.getNextDate((Date)date);
            ScheduleEvents scheduleEvents = eventsBySchedule.getValue();
            if (scheduleEvents.getEvents().isEmpty()) continue;
            ArrayList<Object> onDate = new ArrayList<Object>();
            ArrayList<PropertySet> afterDate = new ArrayList<PropertySet>();
            for (PropertySet event : scheduleEvents.getEvents()) {
                Date endTime = event.getDate("act.endTime");
                Date endDate = DateRules.getDate((Date)endTime);
                if (endDate.compareTo(date) == 0 || DateRules.compareTo((Date)midnight, (Date)endTime) == 0) {
                    if (Schedule.isBlockingEvent(event) && onDate.isEmpty()) continue;
                    onDate.add(event);
                    continue;
                }
                if (endDate.compareTo(date) <= 0) continue;
                afterDate.add(event);
            }
            if (onDate.isEmpty()) continue;
            onDate.addAll(afterDate);
            map.put(eventsBySchedule.getKey(), new ScheduleEvents(onDate, scheduleEvents.getModHash()));
        }
        return map;
    }
}

