/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.boarding;

import echopointng.table.TableCellRendererEx;
import echopointng.xhtml.XhtmlFragment;
import java.util.Date;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.TableFactory;
import org.openvpms.web.echo.table.StyleTableCellRenderer;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.AbstractMultiDayScheduleGrid;
import org.openvpms.web.workspace.workflow.appointment.AbstractMultiDayTableModel;
import org.openvpms.web.workspace.workflow.appointment.MultiDayTableModel;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;

public abstract class CheckInOutTableModel
extends MultiDayTableModel {
    public CheckInOutTableModel(AbstractMultiDayScheduleGrid grid, Context context, ScheduleColours colours) {
        super(grid, context, colours);
    }

    public boolean isEmpty() {
        return this.getGrid().getSchedules().isEmpty();
    }

    @Override
    public Object getValueAt(int column, int row) {
        if (this.isEmpty()) {
            return null;
        }
        return super.getValueAt(column, row);
    }

    @Override
    public int getRowCount() {
        return this.isEmpty() ? 1 : super.getRowCount();
    }

    @Override
    protected TableColumnModel createColumnModel(ScheduleEventGrid grid) {
        DefaultTableColumnModel result;
        if (this.isEmpty()) {
            result = new DefaultTableColumnModel();
            Date start = grid.getStartDate();
            int modelIndex = 0;
            ScheduleTableModel.Column scheduleColumn = new ScheduleTableModel.Column(modelIndex++, Messages.get((String)"workflow.scheduling.type"));
            scheduleColumn.setHeaderRenderer((TableCellRenderer)new StyleTableCellRenderer("Table.Header"));
            scheduleColumn.setCellRenderer((TableCellRenderer)this.createEmptyTableCellRenderer());
            result.addColumn((TableColumn)scheduleColumn);
            for (int i = 0; i < grid.getSlots(); ++i) {
                AbstractMultiDayTableModel.DateColumn column = new AbstractMultiDayTableModel.DateColumn(modelIndex++, DateRules.getDate((Date)start, (int)i, (DateUnits)DateUnits.DAYS));
                result.addColumn((TableColumn)column);
            }
        } else {
            result = super.createColumnModel(grid);
        }
        return result;
    }

    protected abstract EmptyTableRenderer createEmptyTableCellRenderer();

    protected class EmptyTableRenderer
    implements TableCellRendererEx {
        private final String messageKey;

        public EmptyTableRenderer(String messageKey) {
            this.messageKey = messageKey;
        }

        public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
            Label label = LabelFactory.create(null, (String)"bold");
            label.setText(Messages.format((String)this.messageKey, (Object[])new Object[]{CheckInOutTableModel.this.getGrid().getStartDate()}));
            Column result = ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{label});
            result.setLayoutData(TableFactory.columnSpan((int)table.getModel().getColumnCount()));
            return result;
        }

        public boolean isSelectionCausingCell(Table table, int column, int row) {
            return false;
        }

        public boolean isActionCausingCell(Table table, int column, int row) {
            return false;
        }

        public XhtmlFragment getTableCellRendererContent(Table table, Object value, int column, int row) {
            return null;
        }
    }
}

