/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.boarding;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;

class CageScheduleGroup {
    private final Entity cageType;
    private final String name;
    private final List<Schedule> schedules = new ArrayList<Schedule>();
    private boolean expanded = false;
    private Label component;

    public CageScheduleGroup(Entity cageType) {
        this.cageType = cageType;
        this.name = cageType != null ? cageType.getName() : Messages.get((String)"workflow.scheduling.appointment.nocage");
        this.component = new Label();
        this.setExpanded(false);
    }

    public Entity getCageType() {
        return this.cageType;
    }

    public String getName() {
        return this.name;
    }

    public void add(Schedule schedule) {
        Schedule previous = this.schedules.size() > 0 ? this.schedules.get(this.schedules.size() - 1) : null;
        this.schedules.add(schedule);
        boolean even = previous == null ? false : (previous.getSchedule().equals(schedule.getSchedule()) ? previous.getRenderEven() : !previous.getRenderEven());
        schedule.setRenderEven(even);
    }

    public List<Schedule> getSchedules() {
        return this.schedules;
    }

    public int getScheduleCount() {
        HashSet<Entity> set = new HashSet<Entity>();
        for (Schedule schedule : this.schedules) {
            set.add(schedule.getSchedule());
        }
        return set.size();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        this.component.setStyleName(expanded ? "CageType.minus" : "CageType.plus");
    }

    public Component getComponent() {
        return this.component;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CageScheduleGroup) {
            return Objects.equals(this.cageType, ((CageScheduleGroup)obj).cageType);
        }
        return false;
    }

    public int hashCode() {
        return this.cageType != null ? this.cageType.hashCode() : this.name.hashCode();
    }
}

