/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.boarding;

import echopointng.LabelEx;
import echopointng.table.TableCellRendererEx;
import echopointng.xhtml.XhtmlFragment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.Table;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.TableFactory;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageRow;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageScheduleGroup;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageTableModel;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;

class CageScheduleCellRenderer
implements TableCellRendererEx {
    CageScheduleCellRenderer() {
    }

    public XhtmlFragment getTableCellRendererContent(Table table, Object value, int column, int row) {
        return null;
    }

    public boolean isSelectionCausingCell(Table table, int column, int row) {
        return false;
    }

    public boolean isActionCausingCell(Table table, int column, int row) {
        CageTableModel model = (CageTableModel)table.getModel();
        CageRow cageRow = model.getCageRow(row);
        return cageRow.isSummary() && !cageRow.isTotal();
    }

    public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
        CageRow cageRow = (CageRow)value;
        Label name = LabelFactory.create(null, (String)"bold");
        name.setText(cageRow.getName());
        Component result = cageRow.isTotal() ? this.getTotal(table, name) : (cageRow.isSummary() ? this.getCageType(cageRow, name) : this.getSchedule(table, cageRow, name, row));
        return result;
    }

    private Component getTotal(Table table, Label name) {
        CageTableModel model = (CageTableModel)table.getModel();
        Label count = this.getCount(model.getGrid().getScheduleCount());
        LabelEx spacer = new LabelEx(new XhtmlFragment("<div>&#160;</div>"));
        spacer.setStyleName("CageTable.spacer");
        Row right = RowFactory.create((String)"CellSpacing", (LayoutData)RowFactory.rightAlign(), (Component[])new Component[]{count, spacer});
        Row result = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{name, right});
        TableHelper.mergeStyle((Component)result, (String)"ScheduleTable.Even");
        return result;
    }

    private Component getCageType(CageRow cageRow, Label name) {
        CageScheduleGroup group = cageRow.getGroup();
        Label count = this.getCount(group.getScheduleCount());
        LabelEx action = new LabelEx();
        if (group.isExpanded()) {
            action.setStyleName("CageTable.minus");
        } else {
            action.setStyleName("CageTable.plus");
        }
        Row right = RowFactory.create((String)"CellSpacing", (LayoutData)RowFactory.rightAlign(), (Component[])new Component[]{count, action});
        Row result = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{name, right});
        TableHelper.mergeStyle((Component)result, (String)"ScheduleTable.Even");
        return result;
    }

    private Component getSchedule(Table table, CageRow cageRow, Label name, int row) {
        Schedule next;
        String styleName = cageRow.renderEven() ? "ScheduleTable.Even-InsetX" : "ScheduleTable.Odd-InsetX";
        Entity schedule = cageRow.getSchedule().getSchedule();
        ++row;
        int span = 1;
        CageTableModel model = (CageTableModel)table.getModel();
        while (row < model.getRowCount() && (next = model.getSchedule(0, row)) != null && next.getSchedule().equals(schedule)) {
            ++span;
            ++row;
        }
        if (span > 1) {
            name.setLayoutData((LayoutData)TableFactory.rowSpan((int)span));
        }
        TableHelper.mergeStyle((Component)name, (String)styleName);
        return name;
    }

    private Label getCount(int count) {
        Label label = LabelFactory.create(null, (String)"bold");
        label.setText(Integer.toString(count));
        return label;
    }
}

