/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.button.ButtonGroup;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.MessageDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeriesState;

public abstract class SeriesDialog
extends MessageDialog {
    private final ScheduleEventSeriesState series;
    private RadioButton single;
    private RadioButton future;
    private RadioButton all;

    public SeriesDialog(String title, String message, ScheduleEventSeriesState series, HelpContext help) {
        super(title, message, OK_CANCEL, help);
        this.series = series;
        ButtonGroup group = new ButtonGroup();
        this.single = ButtonFactory.create(null, (ButtonGroup)group, this::onOK);
        this.single.setText(Messages.format((String)"workflow.scheduling.appointment.series.single", (Object[])new Object[]{series.getDisplayName()}));
        this.single.setSelected(true);
        if (series.canEditFuture()) {
            this.future = ButtonFactory.create(null, (ButtonGroup)group, this::onOK);
            this.future.setText(Messages.format((String)"workflow.scheduling.appointment.series.future", (Object[])new Object[]{series.getDisplayName()}));
        }
        if (series.canEditSeries()) {
            this.all = ButtonFactory.create((String)"workflow.scheduling.appointment.series.all", (ButtonGroup)group, this::onOK);
        }
    }

    public boolean single() {
        return this.single.isSelected();
    }

    public boolean future() {
        return this.future != null && this.future.isSelected();
    }

    public boolean all() {
        return this.all != null && this.all.isSelected();
    }

    protected void onOK() {
        if (this.future()) {
            List<String> statuses = this.series.getFutureNonPendingStatuses();
            if (!statuses.isEmpty()) {
                this.confirm(statuses);
            } else {
                super.onOK();
            }
        } else if (this.all()) {
            List<String> statuses = this.series.getNonPendingStatuses();
            if (!statuses.isEmpty()) {
                this.confirm(statuses);
            } else {
                super.onOK();
            }
        } else {
            super.onOK();
        }
    }

    protected void doLayout() {
        Label message = LabelFactory.create((boolean)true, (boolean)true);
        message.setText(this.getMessage());
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{message, this.single});
        if (this.future != null) {
            column.add((Component)this.future);
        }
        if (this.all != null) {
            column.add((Component)this.all);
        }
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
    }

    private void confirm(List<String> statuses) {
        String message;
        Map names = LookupNameHelper.getLookupNames((String)"act.customerAppointment", (String)"status");
        if (statuses.size() == 1) {
            message = Messages.format((String)"workflow.scheduling.appointment.series.nonpending1", (Object[])new Object[]{names.get(statuses.get(0))});
        } else {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < statuses.size() - 1; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append((String)names.get(statuses.get(i)));
            }
            String last = (String)names.get(statuses.get(statuses.size() - 1));
            message = Messages.format((String)"workflow.scheduling.appointment.series.nonpending2", (Object[])new Object[]{buffer, last});
        }
        ConfirmationDialog dialog = new ConfirmationDialog(this.getTitle(), message);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                SeriesDialog.super.onOK();
            }

            public void onCancel() {
                SeriesDialog.super.onCancel();
            }
        });
        dialog.show();
    }
}

